/*
 * Decompiled with CFR 0.152.
 */
package org.ivangeevo.animageddon.mixin.entity;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import java.util.function.Consumer;
import net.minecraft.class_1268;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1428;
import net.minecraft.class_1429;
import net.minecraft.class_1430;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_3417;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import org.ivangeevo.animageddon.data.ModDataAttachments;
import org.ivangeevo.animageddon.data.attachments.ChickenEggAttachedData;
import org.ivangeevo.animageddon.data.attachments.CowMilkAttachedData;
import org.ivangeevo.animageddon.data.attachments.hunger.AnimalHungerAttachedData;
import org.ivangeevo.animageddon.entity.interfaces.AnimalEntityAdded;
import org.ivangeevo.animageddon.util.ServerTimeHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1429.class})
public abstract class AnimalEntityMixin
extends class_1296
implements AnimalEntityAdded {
    @Unique
    public int grazeProgressCounter = 0;

    protected AnimalEntityMixin(class_1299<? extends class_1296> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Override
    public int getGrazeProgressCounter() {
        return this.grazeProgressCounter;
    }

    @Override
    public void setGrazeProgressCounter(int value) {
        this.grazeProgressCounter = value;
    }

    @ModifyReturnValue(method={"canEat"}, at={@At(value="RETURN")})
    private boolean modifyCanEat(boolean original) {
        class_1428 chicken;
        class_1429 class_14292 = (class_1429)this;
        if (!(class_14292 instanceof class_1428) || (chicken = (class_1428)class_14292).method_6109()) {
            return original;
        }
        ChickenEggAttachedData data = (ChickenEggAttachedData)chicken.getAttached(ModDataAttachments.CHICKEN_EGG_DATA);
        if (data == null) {
            return original;
        }
        return original && !data.getHasBeenFed();
    }

    @Inject(method={"canBreedWith"}, at={@At(value="HEAD")}, cancellable=true)
    private void onLovePlayer(class_1429 other, CallbackInfoReturnable<Boolean> cir) {
        this.forAnimalSubclass(class_1428.class, chicken -> cir.setReturnValue((Object)false));
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onInit(class_1299<?> entityType, class_1937 world, CallbackInfo ci) {
        this.forAnimalSubclass(class_1428.class, chicken -> {
            ChickenEggAttachedData eggData = (ChickenEggAttachedData)chicken.getAttachedOrCreate(ModDataAttachments.CHICKEN_EGG_DATA, ChickenEggAttachedData::forDefault);
            chicken.setAttached(ModDataAttachments.CHICKEN_EGG_DATA, (Object)eggData);
        });
        this.forAnimalSubclass(class_1430.class, cow -> {
            CowMilkAttachedData milkData = (CowMilkAttachedData)cow.getAttachedOrCreate(ModDataAttachments.MILK_DATA, CowMilkAttachedData::forDefault);
            cow.setAttached(ModDataAttachments.MILK_DATA, (Object)milkData);
        });
    }

    @Inject(method={"mobTick"}, at={@At(value="HEAD")})
    private void onMobTick(CallbackInfo ci) {
        this.forAnimalSubclass(class_1428.class, chicken -> {
            ChickenEggAttachedData eggData = (ChickenEggAttachedData)chicken.getAttached(ModDataAttachments.CHICKEN_EGG_DATA);
            if (eggData == null) {
                return;
            }
            class_1937 world = chicken.method_37908();
            if (!world.field_9236) {
                chicken.field_6739 = Integer.MAX_VALUE;
                long currentTime = world.method_8510();
                if (!chicken.method_6109() && eggData.getTimeToLayEgg() > 0L && eggData.validateTimeToLayEgg(currentTime) && world.method_8532() > eggData.getTimeToLayEgg()) {
                    chicken.method_56078(class_3417.field_14863);
                    chicken.method_56078(class_3417.field_14601);
                    chicken.method_5706((class_1935)class_1802.field_8803);
                    eggData.resetData();
                }
            }
        });
        this.forAnimalSubclass(class_1430.class, cow -> {
            CowMilkAttachedData milkData = (CowMilkAttachedData)cow.getAttached(ModDataAttachments.MILK_DATA);
            if (milkData == null) {
                return;
            }
            if (!cow.method_6109() && !cow.method_37908().field_9236) {
                milkData.tick();
            }
        });
    }

    private void onMobTick1(CallbackInfo ci) {
        this.forAnimalSubclass(class_1430.class, cow -> {
            if (!cow.method_37908().field_9236) {
                // empty if block
            }
        });
    }

    @Inject(method={"eat"}, at={@At(value="HEAD")})
    private void onEatChicken(class_1657 player, class_1268 hand, class_1799 stack, CallbackInfo ci) {
        this.forAnimalSubclass(class_1428.class, chicken -> {
            if (!chicken.method_6109()) {
                long currentTime = ServerTimeHelper.getOverworldTimeOfDayServerOnly();
                ChickenEggAttachedData eggData = (ChickenEggAttachedData)chicken.getAttached(ModDataAttachments.CHICKEN_EGG_DATA);
                if (eggData == null) {
                    return;
                }
                if (eggData.getHasBeenFed()) {
                    return;
                }
                if (stack.method_31573(class_3489.field_49943)) {
                    long timeToLayEgg = ((currentTime + 12000L) / 24000L + 1L) * 24000L;
                    chicken.method_5783(class_3417.field_14601, 1.0f, chicken.method_59922().method_43057() * 0.2f + 1.5f);
                    eggData.setTimeToLayEgg(timeToLayEgg += (long)(-1450 + chicken.method_59922().method_43048(600)));
                    eggData.setHasBeenFed(true);
                    chicken.setAttached(ModDataAttachments.CHICKEN_EGG_DATA, (Object)eggData);
                }
            }
        });
    }

    @Override
    public void initHungerWithVariance() {
        class_1429 animal = (class_1429)this;
        AnimalHungerAttachedData data = (AnimalHungerAttachedData)animal.getAttached(ModDataAttachments.ANIMAL_HUNGER_DATA);
        if (data == null) {
            return;
        }
        if (animal.isSubjectToHunger()) {
            data.setHungerCountdown(24000 - animal.method_59922().method_43048(data.getGrazeHungerGain()));
        }
    }

    @Override
    public boolean canGrazeOnBlock(class_2338 pos) {
        class_1937 world = this.method_37908();
        class_2248 block = world.method_8320(pos).method_26204();
        if (block != null) {
            return block.canBeGrazedOn((class_1936)world, pos, (class_1429)this);
        }
        return false;
    }

    @Override
    public class_2338 getGrazeBlockForPos() {
        class_2338 pos = this.method_24515();
        class_2338 targetPos = new class_2338(class_3532.method_15375((float)pos.method_10263()), (int)this.method_5829().field_1322, class_3532.method_15375((float)pos.method_10260()));
        if (this.canGrazeOnBlock(targetPos)) {
            return targetPos;
        }
        class_2338 newTargetPos = targetPos.method_10074();
        if (this.canGrazeOnBlock(newTargetPos)) {
            return targetPos;
        }
        return null;
    }

    @Override
    public boolean isSubjectToHunger() {
        return false;
    }

    @Override
    public boolean isHungryEnoughToGraze() {
        AnimalHungerAttachedData hungerData = (AnimalHungerAttachedData)this.getAttached(ModDataAttachments.ANIMAL_HUNGER_DATA);
        if (hungerData == null) {
            return false;
        }
        return !hungerData.isFullyFed() || hungerData.getHungerCountdown() + hungerData.getGrazeHungerGain() <= 24000;
    }

    @Override
    public boolean shouldNotifyBlockOnGraze() {
        return true;
    }

    @Override
    public void onStarvingCountExpired() {
        this.method_5643(this.method_48923().method_48825(), 5.0f);
    }

    @Override
    public void addToHungerCount(int addedHunger) {
        int hungerLevel;
        AnimalHungerAttachedData hungerData = (AnimalHungerAttachedData)this.getAttached(ModDataAttachments.ANIMAL_HUNGER_DATA);
        if (hungerData == null) {
            return;
        }
        int hungerCountdown = hungerData.getHungerCountdown();
        hungerData.setHungerCountdown(hungerCountdown + addedHunger);
        if (hungerCountdown > 25500 && (hungerLevel = hungerData.getHungerLevel()) > 0) {
            hungerData.setHungerCountdown(hungerCountdown - 24000);
            hungerData.setHungerLevel(hungerLevel - 1);
        }
    }

    @Override
    public void onGrazeBlock(class_2338 pos) {
        AnimalHungerAttachedData hungerData = (AnimalHungerAttachedData)this.getAttached(ModDataAttachments.ANIMAL_HUNGER_DATA);
        if (hungerData == null) {
            return;
        }
        this.addToHungerCount(hungerData.getGrazeHungerGain());
    }

    private void onEatCow(class_1657 player, class_1268 hand, class_1799 stack, CallbackInfo ci) {
        class_1430 cow;
        class_1429 class_14292 = (class_1429)this;
        if (class_14292 instanceof class_1430 && !(cow = (class_1430)class_14292).method_6109()) {
            long currentTime = ServerTimeHelper.getOverworldTimeOfDayServerOnly();
            ChickenEggAttachedData data = (ChickenEggAttachedData)cow.getAttachedOrCreate(ModDataAttachments.CHICKEN_EGG_DATA, ChickenEggAttachedData::forDefault);
            if (data == null || data.getHasBeenFed() || stack.method_31573(class_3489.field_49933)) {
                // empty if block
            }
        }
    }

    @Unique
    private <T extends class_1429> void forAnimalSubclass(Class<T> type, Consumer<T> action) {
        if (type.isInstance(this)) {
            action.accept((class_1429)this);
        }
    }
}

