/*
 * Decompiled with CFR 0.152.
 */
package org.ivangeevo.animageddon.item.items;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3532;
import org.ivangeevo.animageddon.util.WoolColorsHelper;
import org.ivangeevo.animageddon.util.WoolType;

public class WoolItem
extends class_1792 {
    private static final List<List<Integer>> colorConversionArray = new LinkedList<List<Integer>>();
    private static final Map<WoolType, Integer> colorMap = new HashMap<WoolType, Integer>();
    public static final int[] woolColors = new int[]{0x101010, 11743532, 3887386, 5320730, 2437522, 8073150, 2651799, 0x838383, 0x434343, 14188952, 4312372, 14602026, 6719955, 12801229, 15435844, 0xFFFFFF};

    public WoolItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public static int averageWoolColorsInGrid(class_1263 inventory) {
        int iAverageColor = 0;
        int iSumRed = 0;
        int iSumGreen = 0;
        int iSumBlue = 0;
        int iWoolCount = 0;
        for (int iTempSlot = 0; iTempSlot < inventory.method_5439(); ++iTempSlot) {
            class_1799 tempStack = inventory.method_5438(iTempSlot);
            if (tempStack == null || !tempStack.method_7960()) continue;
            int iWoolColorIndex = class_3532.method_15340((int)tempStack.method_7919(), (int)0, (int)15);
            int iWoolColor = WoolColorsHelper.woolColors[iWoolColorIndex];
            ++iWoolCount;
            iSumRed += iWoolColor >> 16 & 0xFF;
            iSumGreen += iWoolColor >> 8 & 0xFF;
            iSumBlue += iWoolColor & 0xFF;
        }
        if (iWoolCount > 0) {
            int iAverageRed = iSumRed / iWoolCount;
            int iAverageGreen = iSumGreen / iWoolCount;
            int iAverageBlue = iSumBlue / iWoolCount;
            iAverageColor = iAverageRed << 16 | iAverageGreen << 8 | iAverageBlue;
        }
        return iAverageColor;
    }

    private static void initColorConversionArray() {
        colorConversionArray.clear();
        for (int iTempIndex = 0; iTempIndex < 16; ++iTempIndex) {
            LinkedList<Integer> tempColorList = new LinkedList<Integer>();
            colorConversionArray.add(iTempIndex, tempColorList);
            tempColorList.add(WoolColorsHelper.woolColors[iTempIndex]);
        }
        WoolItem.setHardColorConversionPoint(8, 0, 15);
        WoolItem.setHardColorConversionPoint(9, 1, 15);
        WoolItem.setHardColorConversionPoint(14, 1, 11);
        WoolItem.setHardColorConversionPoint(9, 2, 10);
        WoolItem.setHardColorConversionPoint(5, 4, 1);
        WoolItem.setHardColorConversionPoint(6, 4, 2);
        WoolItem.setHardColorConversionPoint(12, 4, 15);
        WoolItem.setHardColorConversionPoint(13, 5, 9);
        WoolItem.setHardColorConversionPoint(7, 8, 15);
    }

    private static void setHardColorConversionPoint(int iToColorIndex, int iFromColorIndex1, int iFromColorIndex2) {
        int iFromColor1 = WoolColorsHelper.woolColors[iFromColorIndex1];
        int iFromColor2 = WoolColorsHelper.woolColors[iFromColorIndex2];
        int iBlendedRed = ((iFromColor1 >> 16 & 0xFF) + (iFromColor2 >> 16 & 0xFF)) / 2;
        int iBlendedGreen = ((iFromColor1 >> 8 & 0xFF) + (iFromColor2 >> 8 & 0xFF)) / 2;
        int iBlendedBlue = ((iFromColor1 & 0xFF) + (iFromColor2 & 0xFF)) / 2;
        int iBlendedColor = iBlendedRed << 16 | iBlendedGreen << 8 | iBlendedBlue;
        colorConversionArray.get(iToColorIndex).add(iBlendedColor);
    }

    public static int getClosestColorIndex(int iColor) {
        int iClosestIndex = -1;
        int iClosestColorDistanceSq = 0;
        int iColorRed = iColor >> 16 & 0xFF;
        int iColorGreen = iColor >> 8 & 0xFF;
        int iColorBlue = iColor & 0xFF;
        if (colorConversionArray == null) {
            WoolItem.initColorConversionArray();
        }
        if (class_3532.method_15382((int)(iColorRed - iColorGreen)) > 5 || class_3532.method_15382((int)(iColorRed - iColorBlue)) > 5) {
            for (int iTempIndex = 0; iTempIndex < 16; ++iTempIndex) {
                List<Integer> tempColorList = colorConversionArray.get(iTempIndex);
                for (int iTempColor : tempColorList) {
                    int iTempColorRed = iTempColor >> 16 & 0xFF;
                    int iTempColorGreen = iTempColor >> 8 & 0xFF;
                    int iTempColorBlue = iTempColor & 0xFF;
                    int iTempRedDelta = iTempColorRed - iColorRed;
                    int iTempGreenDelta = iTempColorGreen - iColorGreen;
                    int iTempBlueDelta = iTempColorBlue - iColorBlue;
                    int iTempColorDistanceSq = 2 * iTempRedDelta * iTempRedDelta + 4 * iTempGreenDelta * iTempGreenDelta + 3 * iTempBlueDelta * iTempBlueDelta;
                    if (iClosestIndex != -1 && iTempColorDistanceSq >= iClosestColorDistanceSq) continue;
                    iClosestIndex = iTempIndex;
                    iClosestColorDistanceSq = iTempColorDistanceSq;
                }
            }
        }
        if (iClosestIndex == -1 || iClosestColorDistanceSq > 15000) {
            int iColorTotal = iColorRed + iColorGreen + iColorBlue;
            iClosestIndex = iColorTotal < 125 ? 0 : (iColorTotal < 297 ? 8 : (iColorTotal < 579 ? 7 : 15));
        }
        return iClosestIndex;
    }

    public int getHerbivoreFoodValue(int iItemDamage) {
        return 0;
    }

    public class_1792 setHerbivoreFoodValue(int iFoodValue) {
        return null;
    }

    public class_1792 setAsBasicHerbivoreFood() {
        return null;
    }

    static {
        colorMap.put(WoolType.WHITE, 0xFFFFFF);
        colorMap.put(WoolType.ORANGE, 15435844);
        colorMap.put(WoolType.MAGENTA, 0xBB44BB);
        colorMap.put(WoolType.LIGHT_BLUE, 6724056);
        colorMap.put(WoolType.YELLOW, 14407770);
        colorMap.put(WoolType.LIME, 7049013);
        colorMap.put(WoolType.PINK, 16026507);
        colorMap.put(WoolType.GRAY, 0x434343);
        colorMap.put(WoolType.LIGHT_GRAY, 0x9E9E9E);
        colorMap.put(WoolType.CYAN, 4941725);
        colorMap.put(WoolType.PURPLE, 11159484);
        colorMap.put(WoolType.BLUE, 3949738);
        colorMap.put(WoolType.BROWN, 8606770);
        colorMap.put(WoolType.GREEN, 6192956);
        colorMap.put(WoolType.RED, 11546150);
        colorMap.put(WoolType.BLACK, 0x1E1B1B);
    }
}

