/*
 * Decompiled with CFR 0.152.
 */
package org.ivangeevo.animageddon.mixin.entity;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1428;
import net.minecraft.class_1429;
import net.minecraft.class_1430;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3417;
import net.minecraft.class_3489;
import org.ivangeevo.animageddon.data.ChickenEggAttachedData;
import org.ivangeevo.animageddon.data.CowMilkAttachedData;
import org.ivangeevo.animageddon.data.ModDataAttachments;
import org.ivangeevo.animageddon.entity.interfaces.AnimalEntityAdded;
import org.ivangeevo.animageddon.util.ServerTimeHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1429.class})
public abstract class AnimalEntityMixin
extends class_1296
implements AnimalEntityAdded {
    protected AnimalEntityMixin(class_1299<? extends class_1296> entityType, class_1937 world) {
        super(entityType, world);
    }

    @ModifyReturnValue(method={"canEat"}, at={@At(value="RETURN")})
    private boolean modifyCanEat(boolean original) {
        class_1428 chicken;
        class_1429 class_14292 = (class_1429)this;
        if (!(class_14292 instanceof class_1428) || (chicken = (class_1428)class_14292).method_6109()) {
            return original;
        }
        ChickenEggAttachedData data = (ChickenEggAttachedData)chicken.getAttachedOrCreate(ModDataAttachments.CHICKEN_EGG_DATA, () -> ChickenEggAttachedData.DEFAULT);
        if (data == null) {
            return original;
        }
        return original && !data.getHasBeenFed();
    }

    @Inject(method={"canBreedWith"}, at={@At(value="HEAD")}, cancellable=true)
    private void onLovePlayer(class_1429 other, CallbackInfoReturnable<Boolean> cir) {
        if ((class_1429)this instanceof class_1428) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"mobTick"}, at={@At(value="HEAD")})
    private void onMobTick(CallbackInfo ci) {
        class_1428 chicken;
        Object data;
        class_1430 cow;
        class_1429 class_14292 = (class_1429)this;
        if (class_14292 instanceof class_1430 && !(cow = (class_1430)class_14292).method_6109() && !cow.method_37908().field_9236) {
            data = (CowMilkAttachedData)cow.getAttachedOrCreate(ModDataAttachments.MILK_DATA, () -> CowMilkAttachedData.DEFAULT);
            ((CowMilkAttachedData)data).tick();
            cow.setAttached(ModDataAttachments.MILK_DATA, data);
        }
        if ((data = (class_1429)this) instanceof class_1428 && !(chicken = (class_1428)data).method_6109() && !chicken.method_37908().field_9236) {
            data = (ChickenEggAttachedData)chicken.getAttachedOrCreate(ModDataAttachments.CHICKEN_EGG_DATA, () -> ChickenEggAttachedData.DEFAULT);
            ((ChickenEggAttachedData)data).tick(chicken);
            chicken.setAttached(ModDataAttachments.CHICKEN_EGG_DATA, data);
        }
    }

    @Inject(method={"eat"}, at={@At(value="HEAD")})
    private void onEatChicken(class_1657 player, class_1268 hand, class_1799 stack, CallbackInfo ci) {
        class_1428 chicken;
        class_1429 class_14292 = (class_1429)this;
        if (class_14292 instanceof class_1428 && !(chicken = (class_1428)class_14292).method_6109()) {
            long currentTime = ServerTimeHelper.getOverworldTimeOfDayServerOnly();
            ChickenEggAttachedData data = (ChickenEggAttachedData)chicken.getAttachedOrCreate(ModDataAttachments.CHICKEN_EGG_DATA, () -> ChickenEggAttachedData.DEFAULT);
            if (data != null && !data.getHasBeenFed() && stack.method_31573(class_3489.field_49943)) {
                long timeToLayEgg = ((currentTime + 12000L) / 24000L + 1L) * 24000L;
                chicken.method_5783(class_3417.field_14601, 1.0f, chicken.method_59922().method_43057() * 0.2f + 1.5f);
                data.setTimeToLayEgg(timeToLayEgg += (long)(-1450 + chicken.method_59922().method_43048(600)));
                data.setHasBeenFed(true);
                chicken.setAttached(ModDataAttachments.CHICKEN_EGG_DATA, (Object)data);
            }
        }
    }

    private void onEatCow(class_1657 player, class_1268 hand, class_1799 stack, CallbackInfo ci) {
        class_1430 cow;
        class_1429 class_14292 = (class_1429)this;
        if (class_14292 instanceof class_1430 && !(cow = (class_1430)class_14292).method_6109()) {
            long currentTime = ServerTimeHelper.getOverworldTimeOfDayServerOnly();
            ChickenEggAttachedData data = (ChickenEggAttachedData)cow.getAttachedOrCreate(ModDataAttachments.CHICKEN_EGG_DATA, () -> ChickenEggAttachedData.DEFAULT);
            if (data == null || data.getHasBeenFed() || stack.method_31573(class_3489.field_49933)) {
                // empty if block
            }
        }
    }

    private void onInteractMob(class_1657 player, class_1268 hand, CallbackInfoReturnable<class_1269> cir) {
        class_1428 chicken;
        class_1429 class_14292 = (class_1429)this;
        if (class_14292 instanceof class_1428 && !(chicken = (class_1428)class_14292).method_6109()) {
            class_1799 stack;
            long currentTime = ServerTimeHelper.getOverworldTimeOfDayServerOnly();
            ChickenEggAttachedData data = (ChickenEggAttachedData)chicken.getAttachedOrCreate(ModDataAttachments.CHICKEN_EGG_DATA, () -> ChickenEggAttachedData.DEFAULT);
            if (data != null && !data.getHasBeenFed() && (stack = player.method_5998(hand)).method_31573(class_3489.field_49943)) {
                long timeToLayEgg = ((currentTime + 12000L) / 24000L + 1L) * 24000L;
                chicken.method_5783(class_3417.field_14601, 1.0f, chicken.method_59922().method_43057() * 0.2f + 1.5f);
                data.setTimeToLayEgg(timeToLayEgg += (long)(-1450 + chicken.method_59922().method_43048(600)));
                data.setHasBeenFed(true);
                chicken.setAttached(ModDataAttachments.CHICKEN_EGG_DATA, (Object)data);
            }
        }
    }
}

