/*
 * Decompiled with CFR 0.152.
 */
package no.vestlandetmc.elevator;

import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.io.File;
import java.io.IOException;
import lombok.Generated;
import no.vestlandetmc.elevator.Listener.ElevatorListener;
import no.vestlandetmc.elevator.Listener.TeleporterListener;
import no.vestlandetmc.elevator.commands.ElevatorCommand;
import no.vestlandetmc.elevator.commands.TeleporterCommand;
import no.vestlandetmc.elevator.config.Config;
import no.vestlandetmc.elevator.config.TeleporterData;
import no.vestlandetmc.elevator.handler.MessageHandler;
import no.vestlandetmc.elevator.handler.Permissions;
import no.vestlandetmc.elevator.handler.UpdateNotification;
import no.vestlandetmc.elevator.hooks.HookManager;
import no.vestlandetmc.elevator.shaded.bstats.bukkit.Metrics;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ElevatorPlugin
extends JavaPlugin {
    private static ElevatorPlugin plugin;
    private FileConfiguration data;

    public void onEnable() {
        plugin = this;
        MessageHandler.sendConsole("<aqua>___________ __                       __                ");
        MessageHandler.sendConsole("<aqua>\\_   _____/|  |   _______  _______ _/  |_  ___________ ");
        MessageHandler.sendConsole("<aqua> |    __)_ |  | _/ __ \\  \\/ /\\__  \\\\   __\\/  _ \\_  __ \\");
        MessageHandler.sendConsole("<aqua> |        \\|  |_\\  ___/\\   /  / __ \\|  | (  <_> )  | \\/");
        MessageHandler.sendConsole("<aqua>/_______  /|____/\\___  >\\_/  (____  /__|  \\____/|__|   ");
        MessageHandler.sendConsole("<aqua>        \\/           \\/           \\/                   ");
        MessageHandler.sendConsole("");
        MessageHandler.sendConsole("<aqua>Elevator v" + this.getPluginMeta().getVersion());
        MessageHandler.sendConsole("<aqua>Running on " + this.getServer().getName());
        MessageHandler.sendConsole("<aqua>Author: Baktus_79");
        MessageHandler.sendConsole("<dark_gray><u>_______________________________________________________");
        MessageHandler.sendConsole("");
        Config.initialize();
        this.createDatafile();
        Permissions.register();
        TeleporterData.createSection();
        HookManager.initialize();
        MessageHandler.sendConsole("<dark_gray><u>_______________________________________________________");
        this.getServer().getPluginManager().registerEvents((Listener)new ElevatorListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new TeleporterListener(), (Plugin)this);
        this.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, commands -> {
            ((Commands)commands.registrar()).register("elevator", "Shows plugin help and reload options.", (BasicCommand)new ElevatorCommand());
            ((Commands)commands.registrar()).register("teleporter", "Manage teleporters.", (BasicCommand)new TeleporterCommand());
        });
        new UpdateNotification(this, "blockelevator"){

            @Override
            public void onUpdateAvailable() {
                MessageHandler.sendConsole("<red>-----------------------");
                MessageHandler.sendConsole("<red>[Elevator] Version " + 1.getLatestVersion() + " is now available!");
                MessageHandler.sendConsole("<red>[Elevator] Download the update at https://modrinth.com/plugin/" + 1.getProjectSlug());
                MessageHandler.sendConsole("<red>-----------------------");
            }
        }.runTaskAsynchronously((Plugin)this);
        int pluginId = 22614;
        Metrics metrics = new Metrics((Plugin)this, 22614);
    }

    public void reload() {
        Config.initialize();
    }

    public FileConfiguration getDataFile() {
        return this.data;
    }

    public void createDatafile() {
        File dataFile = new File(this.getDataFolder(), "data.dat");
        if (!dataFile.exists()) {
            dataFile.getParentFile().mkdirs();
            try {
                dataFile.createNewFile();
            }
            catch (IOException e) {
                this.getLogger().severe(e.getMessage());
            }
        }
        this.data = new YamlConfiguration();
        try {
            this.data.load(dataFile);
        }
        catch (IOException | InvalidConfigurationException e) {
            this.getLogger().severe(e.getMessage());
        }
    }

    @Generated
    public static ElevatorPlugin getPlugin() {
        return plugin;
    }
}

