/*
 * Decompiled with CFR 0.152.
 */
package no.vestlandetmc.elevator.Listener;

import no.vestlandetmc.elevator.config.Config;
import no.vestlandetmc.elevator.handler.Cooldown;
import no.vestlandetmc.elevator.handler.GDHandler;
import no.vestlandetmc.elevator.handler.GPHandler;
import no.vestlandetmc.elevator.handler.Mechanics;
import no.vestlandetmc.elevator.handler.MessageHandler;
import no.vestlandetmc.elevator.handler.Permissions;
import no.vestlandetmc.elevator.handler.UpdateNotification;
import no.vestlandetmc.elevator.handler.WGHandler;
import no.vestlandetmc.elevator.hooks.HookManager;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;

public class ElevatorListener
implements Listener {
    @EventHandler
    public void onPlayerMoveEvent(PlayerMoveEvent e) {
        if (e.getPlayer().getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        if (!e.getPlayer().isOnGround() && e.getPlayer().getVelocity().getY() > 0.0) {
            if (!Mechanics.standOnBlock(e.getPlayer().getLocation(), Config.ELEVATOR_BLOCK_TYPE)) {
                return;
            }
            Location tpLocation = Mechanics.getElevatorLocationUp(e.getPlayer());
            if (tpLocation != null) {
                if (!e.getPlayer().hasPermission(Permissions.ELEVATOR_USE)) {
                    return;
                }
                if (Config.COOLDOWN_ENABLED && Cooldown.elevatorUsed(e.getPlayer())) {
                    return;
                }
                if (HookManager.isGriefPreventionLoaded() && Config.GRIEFPREVENTION_HOOK && !GPHandler.haveTrust(e.getPlayer())) {
                    return;
                }
                if (HookManager.isWorldGuardLoaded() && Config.WORLDGUARD_HOOK && !WGHandler.haveTrust(e.getPlayer())) {
                    return;
                }
                if (HookManager.isGriefDefenderLoaded() && Config.GRIEFDEFENDER_HOOK && !GDHandler.haveTrust(e.getPlayer())) {
                    return;
                }
                Mechanics.setParticles(e.getPlayer());
                Mechanics.teleport(e.getPlayer(), tpLocation);
                MessageHandler.sendAction(e.getPlayer(), Config.ELEVATOR_LOCALE_UP);
            }
        }
    }

    @EventHandler
    public void onPlayerToggleSneakEvent(PlayerToggleSneakEvent e) {
        if (!e.getPlayer().isSneaking()) {
            if (e.getPlayer().getGameMode() == GameMode.SPECTATOR) {
                return;
            }
            if (!Mechanics.standOnBlock(e.getPlayer().getLocation(), Config.ELEVATOR_BLOCK_TYPE)) {
                return;
            }
            Location tpLocation = Mechanics.getElevatorLocationDown(e.getPlayer());
            if (tpLocation != null) {
                if (!e.getPlayer().hasPermission(Permissions.ELEVATOR_USE)) {
                    return;
                }
                if (Config.COOLDOWN_ENABLED && Cooldown.elevatorUsed(e.getPlayer())) {
                    return;
                }
                if (HookManager.isGriefPreventionLoaded() && Config.GRIEFPREVENTION_HOOK && !GPHandler.haveTrust(e.getPlayer())) {
                    return;
                }
                if (HookManager.isWorldGuardLoaded() && Config.WORLDGUARD_HOOK && !WGHandler.haveTrust(e.getPlayer())) {
                    return;
                }
                if (HookManager.isGriefDefenderLoaded() && Config.GRIEFDEFENDER_HOOK && !GDHandler.haveTrust(e.getPlayer())) {
                    return;
                }
                Mechanics.setParticles(e.getPlayer());
                Mechanics.teleport(e.getPlayer(), tpLocation);
                MessageHandler.sendAction(e.getPlayer(), Config.ELEVATOR_LOCALE_DOWN);
            }
        }
    }

    @EventHandler
    public void BlockPlaceEvent(BlockPlaceEvent e) {
        World w = e.getPlayer().getWorld();
        if (this.blockExistClose(e) && e.getBlockPlaced().getType() == Config.ELEVATOR_BLOCK_TYPE) {
            if (!e.getPlayer().hasPermission(Permissions.ELEVATOR_USE)) {
                return;
            }
            for (double y = 50.0; y > -51.0; y -= 1.0) {
                if (!(y + e.getBlockPlaced().getLocation().getY() > e.getBlockPlaced().getLocation().getY() + 2.0) && !(y + e.getBlockPlaced().getLocation().getY() < e.getBlockPlaced().getLocation().getY() - 2.0) || w.getBlockAt(e.getBlockPlaced().getLocation().add(0.0, y, 0.0)).getType() != Config.ELEVATOR_BLOCK_TYPE) continue;
                MessageHandler.sendAction(e.getPlayer(), Config.ELEVATOR_LOCALE_ACTIVATED);
                e.getPlayer().playSound(e.getPlayer().getLocation(), "minecraft:" + Config.SOUND_ACTIVATED, 1.0f, 1.0f);
                break;
            }
        }
    }

    @EventHandler
    public void playerJoin(PlayerJoinEvent p) {
        Player player = p.getPlayer();
        if (player.isOp() && UpdateNotification.isUpdateAvailable()) {
            MessageHandler.sendMessage(player, "<green>------------------------------------");
            MessageHandler.sendMessage(player, "<green>Elevator is outdated. Update is available!");
            MessageHandler.sendMessage(player, "<green>Your version is <bold> " + UpdateNotification.getCurrentVersion() + "</bold> and can be updated to version <bold>" + UpdateNotification.getLatestVersion());
            MessageHandler.sendMessage(player, "<green>Get the new update at https://modrinth.com/plugin/" + UpdateNotification.getProjectSlug());
            MessageHandler.sendMessage(player, "<green>------------------------------------");
        }
    }

    private boolean blockExistClose(BlockPlaceEvent e) {
        World w = e.getPlayer().getWorld();
        return w.getBlockAt(e.getBlockPlaced().getLocation().add(0.0, 1.0, 0.0)).getType() != Config.ELEVATOR_BLOCK_TYPE && w.getBlockAt(e.getBlockPlaced().getLocation().add(0.0, 2.0, 0.0)).getType() != Config.ELEVATOR_BLOCK_TYPE && w.getBlockAt(e.getBlockPlaced().getLocation().add(0.0, -1.0, 0.0)).getType() != Config.ELEVATOR_BLOCK_TYPE && w.getBlockAt(e.getBlockPlaced().getLocation().add(0.0, -2.0, 0.0)).getType() != Config.ELEVATOR_BLOCK_TYPE;
    }
}

