/*
 * Decompiled with CFR 0.152.
 */
package no.vestlandetmc.elevator.commands;

import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import no.vestlandetmc.elevator.commands.subcommands.ElevatorHelp;
import no.vestlandetmc.elevator.commands.subcommands.ElevatorReload;
import no.vestlandetmc.elevator.commands.subcommands.SubCommand;
import no.vestlandetmc.elevator.handler.Permissions;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class ElevatorCommand
implements BasicCommand {
    private final Map<String, SubCommand> subcommands = new HashMap<String, SubCommand>();

    public ElevatorCommand() {
        this.register(new ElevatorHelp());
        this.register(new ElevatorReload());
    }

    private void register(SubCommand subCommand) {
        this.subcommands.put(subCommand.getName().toLowerCase(), subCommand);
    }

    public void execute(@NonNull CommandSourceStack commandSourceStack, String[] args) {
        String label;
        SubCommand sub;
        if (args.length == 0) {
            args = new String[]{"help"};
        }
        if ((sub = this.subcommands.get(label = args[0].toLowerCase())) != null) {
            sub.execute(commandSourceStack.getSender(), Arrays.copyOfRange(args, 1, args.length));
        }
    }

    public @NonNull Collection<String> suggest(@NonNull CommandSourceStack commandSourceStack, String @NonNull [] args) {
        if (args.length == 0) {
            return this.subcommands.keySet().stream().toList();
        }
        if (args.length == 1) {
            return this.subcommands.keySet().stream().filter(s -> s.toLowerCase().startsWith(args[0].toLowerCase())).toList();
        }
        SubCommand sub = this.subcommands.get(args[0].toLowerCase());
        if (sub != null) {
            String[] subArgs = Arrays.copyOfRange(args, 1, args.length);
            return sub.suggest(commandSourceStack.getSender(), subArgs);
        }
        return Collections.emptyList();
    }

    public @Nullable String permission() {
        return Permissions.ADMIN.getName();
    }
}

