/*
 * Decompiled with CFR 0.152.
 */
package no.vestlandetmc.elevator.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import no.vestlandetmc.elevator.ElevatorPlugin;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jspecify.annotations.NonNull;

public class ConfigHandler
extends YamlConfiguration {
    private final File file;
    private final YamlConfiguration defaults;
    private String pathPrefix;

    public ConfigHandler(String fileName) {
        this(fileName, true);
    }

    public ConfigHandler(String fileName, boolean useDefaults) {
        this.defaults = useDefaults ? YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(ConfigHandler.class.getResourceAsStream("/" + fileName), StandardCharsets.UTF_8)) : null;
        this.file = this.extract(fileName);
        this.loadConfig();
    }

    public void reloadConfig() {
        this.saveConfig();
        this.loadConfig();
    }

    public void write(String path, Object value) {
        this.set(path, value);
        this.reloadConfig();
    }

    public void saveConfig() {
        try {
            super.save(this.file);
        }
        catch (IOException ex) {
            ElevatorPlugin.getPlugin().getLogger().severe("Failed to save configuration from " + String.valueOf(this.file));
            ElevatorPlugin.getPlugin().getLogger().severe(ex.getMessage());
        }
    }

    private void loadConfig() {
        try {
            super.load(this.file);
        }
        catch (Throwable t) {
            ElevatorPlugin.getPlugin().getLogger().severe("Failed to load configuration from " + String.valueOf(this.file));
            ElevatorPlugin.getPlugin().getLogger().severe(t.getMessage());
        }
    }

    public Object get(@NonNull String path, Object def) {
        if (this.defaults != null) {
            if (def != null && !def.getClass().isPrimitive() && !PrimitiveWrapper.isWrapperType(def.getClass())) {
                throw new IllegalArgumentException("The default value must be null since we use defaults from file inside of the plugin! Path: " + (String)path + ", default called: " + String.valueOf(def));
            }
            if (super.get((String)path, null) == null) {
                Object defaultValue = this.defaults.get((String)path);
                this.write((String)path, defaultValue);
            }
        }
        String m = new Throwable().getStackTrace()[1].getMethodName();
        if (this.defaults == null && this.pathPrefix != null && !m.equals("getConfigurationSection") && !m.equals("get")) {
            path = this.pathPrefix + "." + (String)path;
        }
        return super.get((String)path, null);
    }

    public void set(@NonNull String path, Object value) {
        String m = new Throwable().getStackTrace()[1].getMethodName();
        if (this.defaults == null && this.pathPrefix != null && !m.equals("getConfigurationSection") && !m.equals("get")) {
            path = this.pathPrefix + "." + (String)path;
        }
        super.set((String)path, value);
    }

    private File extract(String path) {
        ElevatorPlugin i = ElevatorPlugin.getPlugin();
        File file = new File(i.getDataFolder(), path);
        if (file.exists()) {
            return file;
        }
        this.createFileAndDirectory(path);
        if (this.defaults != null) {
            try (InputStream is = i.getResource(path);){
                Files.copy(is, Paths.get(file.toURI()), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                ElevatorPlugin.getPlugin().getLogger().severe(e.getMessage());
            }
        }
        return file;
    }

    private File createFileAndDirectory(String path) {
        File datafolder = ElevatorPlugin.getPlugin().getDataFolder();
        int lastIndex = path.lastIndexOf(47);
        File directory = new File(datafolder, path.substring(0, Math.max(lastIndex, 0)));
        directory.mkdirs();
        File destination = new File(datafolder, path);
        try {
            destination.createNewFile();
        }
        catch (IOException ex) {
            ElevatorPlugin.getPlugin().getLogger().severe("Failed to create file " + path);
            ElevatorPlugin.getPlugin().getLogger().severe(ex.getMessage());
        }
        return destination;
    }

    public void removeOutdatedKeys(Set<String> validKeys) {
        for (String key : this.getKeys(true)) {
            if (validKeys.contains(key)) continue;
            this.set(key, null);
        }
        this.saveConfig();
    }

    @Generated
    public void setPathPrefix(String pathPrefix) {
        this.pathPrefix = pathPrefix;
    }

    private static final class PrimitiveWrapper {
        private static final Set<Class<?>> WRAPPER_TYPES = PrimitiveWrapper.getWrapperTypes();

        private PrimitiveWrapper() {
        }

        private static boolean isWrapperType(Class<?> clazz) {
            return WRAPPER_TYPES.contains(clazz);
        }

        private static Set<Class<?>> getWrapperTypes() {
            HashSet ret = new HashSet();
            ret.add(Boolean.class);
            ret.add(Character.class);
            ret.add(Byte.class);
            ret.add(Short.class);
            ret.add(Integer.class);
            ret.add(Long.class);
            ret.add(Float.class);
            ret.add(Double.class);
            ret.add(Void.class);
            return ret;
        }
    }
}

