/*
 * Decompiled with CFR 0.152.
 */
package no.vestlandetmc.elevator.config;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import no.vestlandetmc.elevator.ElevatorPlugin;
import no.vestlandetmc.elevator.config.Config;
import no.vestlandetmc.elevator.handler.MessageHandler;
import no.vestlandetmc.elevator.hooks.VanishManager;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TeleporterData {
    private static final HashMap<String, Long> warmUpTeleporter = new HashMap();

    public static void teleporterUsed(final Player player, final String tpName) {
        if (!warmUpTeleporter.containsKey(player.getUniqueId().toString())) {
            warmUpTeleporter.put(player.getUniqueId().toString(), System.currentTimeMillis() / 1000L);
            new BukkitRunnable(){

                public void run() {
                    if (!warmUpTeleporter.containsKey(player.getUniqueId().toString())) {
                        this.cancel();
                        return;
                    }
                    if (TeleporterData.warmupTime(player) <= 0L) {
                        warmUpTeleporter.remove(player.getUniqueId().toString());
                        player.teleport(TeleporterData.getTeleportLoc(tpName));
                        if (Config.TP_PARTICLE_ENABLE) {
                            TeleporterData.particleTeleporter(player);
                        }
                        player.getWorld().playSound(player.getLocation(), "minecraft:" + Config.TP_SOUND, 1.0f, 0.7f);
                        MessageHandler.sendAction(player, Config.TP_LOCALE_INIT);
                        this.cancel();
                        return;
                    }
                    if (Config.TP_PARTICLE_ENABLE && !VanishManager.isVanished(player)) {
                        TeleporterData.particleTeleporter(player);
                    }
                    MessageHandler.sendAction(player, MessageHandler.placeholders(Config.TP_LOCALE_WARMUP, TeleporterData.warmupTime(player).toString(), null, null, null));
                }
            }.runTaskTimer((Plugin)ElevatorPlugin.getPlugin(), 0L, 2L);
        }
    }

    public static boolean teleporterMove(Player player) {
        if (warmUpTeleporter.containsKey(player.getUniqueId().toString())) {
            warmUpTeleporter.remove(player.getUniqueId().toString());
            return true;
        }
        return false;
    }

    private static Long warmupTime(Player player) {
        if (Config.TP_WARMUP_ENABLE) {
            return 0L;
        }
        if (warmUpTeleporter.containsKey(player.getUniqueId().toString())) {
            return (long)Config.TP_WARMUP_TIME - (System.currentTimeMillis() / 1000L - warmUpTeleporter.get(player.getUniqueId().toString()));
        }
        return 0L;
    }

    private static void particleTeleporter(Player player) {
        Particle.DustOptions options = new Particle.DustOptions(Color.AQUA, 0.5f);
        for (double i = 0.0; i <= Math.PI; i += 0.3141592653589793) {
            double radius = Math.sin(i);
            double y = Math.cos(i) + 1.0;
            for (double a = 0.0; a < Math.PI * 2; a += 0.3141592653589793) {
                double x = Math.cos(a) * radius;
                double z = Math.sin(a) * radius;
                Location loc = player.getLocation().add(x, y, z);
                Particle particle = Particle.DUST;
                player.getWorld().spawnParticle(particle, loc, 0, 0.0, 1.0, 0.0, (Object)options);
            }
        }
    }

    public static void setTeleporter(Player player) {
        block6: {
            double locX = player.getWorld().getBlockAt(player.getLocation()).getX();
            double locY = (double)player.getWorld().getBlockAt(player.getLocation()).getY() - 1.0;
            double locZ = player.getWorld().getBlockAt(player.getLocation()).getZ();
            String world = player.getLocation().getWorld().getName();
            if (!TeleporterData.standOnBlock(player)) {
                MessageHandler.sendMessage(player, Config.TP_LOCALE_UNVALID);
                return;
            }
            Location loc = new Location(Bukkit.getWorld((String)world), locX, locY, locZ);
            if (TeleporterData.teleporterExist(loc)) {
                MessageHandler.sendMessage(player, Config.TP_LOCALE_EXIST);
                return;
            }
            int tpNumberMax = 1;
            if (ElevatorPlugin.getPlugin().getDataFile().contains("Teleporters")) {
                if (!ElevatorPlugin.getPlugin().getDataFile().getConfigurationSection("Teleporters").getKeys(false).isEmpty()) {
                    while (true) {
                        if (!ElevatorPlugin.getPlugin().getDataFile().contains("Teleporters.TP" + tpNumberMax)) {
                            String tpName = "TP" + tpNumberMax;
                            TeleporterData.writeTpName(player, tpNumberMax, locX, locY, locZ, world, tpName);
                            break block6;
                        }
                        ++tpNumberMax;
                    }
                }
                TeleporterData.writeTpName(player, tpNumberMax, locX, locY, locZ, world, "TP1");
            }
        }
    }

    private static boolean standOnBlock(Player player) {
        return player.getWorld().getBlockAt(player.getLocation().add(0.0, -1.0, 0.0)).getType() == Config.TP_BLOCK_TYPE;
    }

    private static void writeTpName(Player player, int tpNumberMax, double locX, double locY, double locZ, String world, String tpName) {
        if (!ElevatorPlugin.getPlugin().getDataFile().contains("Teleporters.TP" + tpNumberMax)) {
            ElevatorPlugin.getPlugin().getDataFile().set("Teleporters." + tpName + ".X", (Object)locX);
            ElevatorPlugin.getPlugin().getDataFile().set("Teleporters." + tpName + ".Y", (Object)locY);
            ElevatorPlugin.getPlugin().getDataFile().set("Teleporters." + tpName + ".Z", (Object)locZ);
            ElevatorPlugin.getPlugin().getDataFile().set("Teleporters." + tpName + ".World", (Object)world);
            ElevatorPlugin.getPlugin().getDataFile().set("Teleporters." + tpName + ".Player", (Object)player.getUniqueId().toString());
            MessageHandler.sendMessage(player, MessageHandler.placeholders(Config.TP_LOCALE_ADDED, null, tpName, null, null));
            TeleporterData.saveDatafile();
        }
    }

    public static Location getTeleportLoc(String tpName) {
        if (ElevatorPlugin.getPlugin().getDataFile().contains("Teleporters." + tpName + ".Destination")) {
            String tpTo = ElevatorPlugin.getPlugin().getDataFile().getString("Teleporters." + tpName + ".Destination");
            double locX = ElevatorPlugin.getPlugin().getDataFile().getDouble("Teleporters." + tpTo + ".X") + 0.5;
            double locY = ElevatorPlugin.getPlugin().getDataFile().getDouble("Teleporters." + tpTo + ".Y") + 1.0;
            double locZ = ElevatorPlugin.getPlugin().getDataFile().getDouble("Teleporters." + tpTo + ".Z") + 0.5;
            World world = Bukkit.getWorld((String)ElevatorPlugin.getPlugin().getDataFile().getString("Teleporters." + tpTo + ".World"));
            return new Location(world, locX, locY, locZ);
        }
        return null;
    }

    public static String getTeleporter(Location loc) {
        if (ElevatorPlugin.getPlugin().getDataFile().getKeys(false).toArray().length != 0 || ElevatorPlugin.getPlugin().getDataFile().getConfigurationSection("Teleporters").getKeys(false).toArray().length != 0) {
            for (String tp : ElevatorPlugin.getPlugin().getDataFile().getConfigurationSection("Teleporters").getKeys(false)) {
                double locX = ElevatorPlugin.getPlugin().getDataFile().getDouble("Teleporters." + tp + ".X");
                double locY = ElevatorPlugin.getPlugin().getDataFile().getDouble("Teleporters." + tp + ".Y");
                double locZ = ElevatorPlugin.getPlugin().getDataFile().getDouble("Teleporters." + tp + ".Z");
                World world = Bukkit.getWorld((String)ElevatorPlugin.getPlugin().getDataFile().getString("Teleporters." + tp + ".World"));
                Location tpLoc = new Location(world, locX, locY, locZ);
                if (!tpLoc.toString().equals(loc.toString())) continue;
                return tp;
            }
        }
        return null;
    }

    private static boolean teleporterExist(Location loc) {
        if (ElevatorPlugin.getPlugin().getDataFile().getKeys(false).toArray().length != 0 || ElevatorPlugin.getPlugin().getDataFile().getConfigurationSection("Teleporters").getKeys(false).toArray().length != 0) {
            for (String tp : ElevatorPlugin.getPlugin().getDataFile().getConfigurationSection("Teleporters").getKeys(false)) {
                double locX = ElevatorPlugin.getPlugin().getDataFile().getDouble("Teleporters." + tp + ".X");
                double locY = ElevatorPlugin.getPlugin().getDataFile().getDouble("Teleporters." + tp + ".Y");
                double locZ = ElevatorPlugin.getPlugin().getDataFile().getDouble("Teleporters." + tp + ".Z");
                World world = Bukkit.getWorld((String)ElevatorPlugin.getPlugin().getDataFile().getString("Teleporters." + tp + ".World"));
                Location tpLoc = new Location(world, locX, locY, locZ);
                if (!tpLoc.toString().equals(loc.toString())) continue;
                return true;
            }
        }
        return false;
    }

    public static void linkTeleporter(Player player, String tp1, String tp2) {
        if (!ElevatorPlugin.getPlugin().getDataFile().contains("Teleporters." + tp1) || !ElevatorPlugin.getPlugin().getDataFile().contains("Teleporters." + tp2)) {
            MessageHandler.sendMessage(player, Config.TP_LOCALE_UNEXIST);
            return;
        }
        if (ElevatorPlugin.getPlugin().getDataFile().contains("Teleporters." + tp1 + ".Destination") || ElevatorPlugin.getPlugin().getDataFile().contains("Teleporters." + tp2 + ".Destination")) {
            MessageHandler.sendMessage(player, Config.TP_LOCALE_LINKEXIST);
            return;
        }
        if (!TeleporterData.checkTpOwner(player, tp1.toUpperCase(), tp2.toUpperCase())) {
            MessageHandler.sendMessage(player, Config.TP_LOCALE_NOOWNER);
            return;
        }
        ElevatorPlugin.getPlugin().getDataFile().set("Teleporters." + tp1 + ".Destination", (Object)tp2);
        ElevatorPlugin.getPlugin().getDataFile().set("Teleporters." + tp2 + ".Destination", (Object)tp1);
        MessageHandler.sendMessage(player, MessageHandler.placeholders(Config.TP_LOCALE_LINKED, null, null, tp1, tp2));
        TeleporterData.saveDatafile();
    }

    public static void deleteTeleporter(Player player, String tpName) {
        if (!ElevatorPlugin.getPlugin().getDataFile().contains("Teleporters." + tpName)) {
            MessageHandler.sendMessage(player, Config.TP_LOCALE_UNEXIST);
            return;
        }
        if (!TeleporterData.checkTpOwner(player, tpName)) {
            MessageHandler.sendMessage(player, Config.TP_LOCALE_NOOWNER);
            return;
        }
        if (ElevatorPlugin.getPlugin().getDataFile().contains("Teleporters." + tpName + ".Destination")) {
            String tpName2 = ElevatorPlugin.getPlugin().getDataFile().getString("Teleporters." + tpName + ".Destination");
            ElevatorPlugin.getPlugin().getDataFile().set("Teleporters." + tpName2 + ".Destination", null);
        }
        ElevatorPlugin.getPlugin().getDataFile().set("Teleporters." + tpName, null);
        MessageHandler.sendMessage(player, MessageHandler.placeholders(Config.TP_LOCALE_REMOVED, null, tpName, null, null));
        TeleporterData.saveDatafile();
    }

    public static void deleteTeleporter(String tpName) {
        if (!ElevatorPlugin.getPlugin().getDataFile().contains("Teleporters." + tpName)) {
            return;
        }
        if (ElevatorPlugin.getPlugin().getDataFile().contains("Teleporters." + tpName + ".Destination")) {
            String tpName2 = ElevatorPlugin.getPlugin().getDataFile().getString("Teleporters." + tpName + ".Destination");
            ElevatorPlugin.getPlugin().getDataFile().set("Teleporters." + tpName2 + ".Destination", null);
        }
        ElevatorPlugin.getPlugin().getDataFile().set("Teleporters." + tpName, null);
        TeleporterData.saveDatafile();
    }

    public static void unlinkTeleporter(Player player, String tpName) {
        if (!ElevatorPlugin.getPlugin().getDataFile().contains("Teleporters." + tpName)) {
            MessageHandler.sendMessage(player, Config.TP_LOCALE_UNEXIST);
            return;
        }
        if (!TeleporterData.checkTpOwner(player, tpName)) {
            MessageHandler.sendMessage(player, Config.TP_LOCALE_NOOWNER);
            return;
        }
        if (ElevatorPlugin.getPlugin().getDataFile().contains("Teleporters." + tpName + ".Destination")) {
            String tpName2 = ElevatorPlugin.getPlugin().getDataFile().getString("Teleporters." + tpName + ".Destination");
            ElevatorPlugin.getPlugin().getDataFile().set("Teleporters." + tpName + ".Destination", null);
            ElevatorPlugin.getPlugin().getDataFile().set("Teleporters." + tpName2 + ".Destination", null);
            MessageHandler.sendMessage(player, MessageHandler.placeholders(Config.TP_LOCALE_UNLINKED, null, null, tpName, tpName2));
            TeleporterData.saveDatafile();
        } else {
            MessageHandler.sendMessage(player, MessageHandler.placeholders(Config.TP_LOCALE_NODEST, null, tpName, null, null));
        }
    }

    public static void listTP(Player player) {
        int count = 0;
        MessageHandler.sendMessage(player, Config.TP_LOCALE_LISTHEADER);
        for (String tp : ElevatorPlugin.getPlugin().getDataFile().getConfigurationSection("Teleporters").getKeys(false)) {
            double locX = ElevatorPlugin.getPlugin().getDataFile().getDouble("Teleporters." + tp + ".X");
            double locY = ElevatorPlugin.getPlugin().getDataFile().getDouble("Teleporters." + tp + ".Y");
            double locZ = ElevatorPlugin.getPlugin().getDataFile().getDouble("Teleporters." + tp + ".Z");
            String world = ElevatorPlugin.getPlugin().getDataFile().getString("Teleporters." + tp + ".World");
            String link = ElevatorPlugin.getPlugin().getDataFile().contains("Teleporters." + tp + ".Destination") ? ElevatorPlugin.getPlugin().getDataFile().getString("Teleporters." + tp + ".Destination") : null;
            if (!TeleporterData.checkTpOwner(player, tp.toUpperCase())) continue;
            ++count;
            if (link == null) {
                MessageHandler.sendMessage(player, "<gold>" + tp + " <yellow>X:<gold>" + locX + " <yellow>Y:<gold>" + locY + " <yellow>Z:<gold>" + locZ + " <yellow>in world <gold>" + world);
                continue;
            }
            MessageHandler.sendMessage(player, "<gold>" + tp + " <yellow>X:<gold>" + locX + " <yellow>Y:<gold>" + locY + " <yellow>Z:<gold>" + locZ + " <yellow>in world <gold>" + world + " <yellow>==> <gold>" + link);
        }
        if (count == 0) {
            MessageHandler.sendMessage(player, Config.TP_LOCALE_LISTNOTP);
        }
    }

    public static List<String> tabCompleteTp(Player player) {
        ArrayList<String> teleportList = new ArrayList<String>();
        for (String tp : ElevatorPlugin.getPlugin().getDataFile().getConfigurationSection("Teleporters").getKeys(false)) {
            if (!TeleporterData.checkTpOwner(player, tp.toUpperCase())) continue;
            teleportList.add(tp.toLowerCase());
        }
        return teleportList;
    }

    private static boolean checkTpOwner(Player player, String tp1, String tp2) {
        String ownerTp1 = ElevatorPlugin.getPlugin().getDataFile().getString("Teleporters." + tp1 + ".Player");
        String ownerTp2 = ElevatorPlugin.getPlugin().getDataFile().getString("Teleporters." + tp2 + ".Player");
        return ownerTp1.equals(player.getUniqueId().toString()) || ownerTp2.equals(player.getUniqueId().toString());
    }

    private static boolean checkTpOwner(Player player, String tp) {
        String ownerTp = ElevatorPlugin.getPlugin().getDataFile().getString("Teleporters." + tp + ".Player");
        return ownerTp.equals(player.getUniqueId().toString());
    }

    public static boolean checkTpPerms(Player player) {
        int allowedTeleporters = 0;
        int teleporterCount = 0;
        if (player.hasPermission("elevator.teleporter.bypass") || player.hasPermission("elevator.admin")) {
            return true;
        }
        for (PermissionAttachmentInfo perms : player.getEffectivePermissions()) {
            if (!perms.getPermission().replaceAll("\\d", "").equals("elevator.teleporter.block.") || Integer.parseInt(perms.getPermission().replaceAll("\\D", "")) <= allowedTeleporters) continue;
            allowedTeleporters = Integer.parseInt(perms.getPermission().replaceAll("\\D", ""));
        }
        if (allowedTeleporters == 0) {
            return false;
        }
        for (String tp : ElevatorPlugin.getPlugin().getDataFile().getConfigurationSection("Teleporters").getKeys(false)) {
            if (!TeleporterData.checkTpOwner(player, tp) || ++teleporterCount < allowedTeleporters * 2) continue;
            return false;
        }
        return true;
    }

    public static void createSection() {
        if (ElevatorPlugin.getPlugin().getDataFile().getKeys(false).isEmpty()) {
            ElevatorPlugin.getPlugin().getDataFile().createSection("Teleporters");
            TeleporterData.saveDatafile();
        }
    }

    private static void saveDatafile() {
        try {
            File file = new File(ElevatorPlugin.getPlugin().getDataFolder(), "data.dat");
            ElevatorPlugin.getPlugin().getDataFile().save(file);
        }
        catch (IOException e) {
            ElevatorPlugin.getPlugin().getLogger().severe(e.getMessage());
        }
    }
}

