/*
 * Decompiled with CFR 0.152.
 */
package no.vestlandetmc.elevator.handler;

import no.vestlandetmc.elevator.config.Config;
import no.vestlandetmc.elevator.handler.MessageHandler;
import no.vestlandetmc.elevator.hooks.VanishManager;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class Mechanics {
    public static boolean standOnBlock(Location location, Material material) {
        return location.getWorld().getBlockAt(location.add(0.0, -1.0, 0.0)).getType() == material;
    }

    public static Location getElevatorLocationUp(Player player) {
        int distance = Config.BLOCK_DISTANCE;
        for (double y = 2.0; y <= (double)distance; y += 1.0) {
            Block block = player.getWorld().getBlockAt(player.getLocation().add(0.0, y, 0.0));
            if (block.getType() != Config.ELEVATOR_BLOCK_TYPE) continue;
            if (Mechanics.dangerBlock(block.getLocation()) && !Config.ELEVATOR_ALLOWUNSAFE) {
                MessageHandler.sendAction(player, Config.ELEVATOR_LOCALE_DANGER);
                return null;
            }
            Location tpCoordinate = block.getLocation().add(0.5, 1.0, 0.5);
            tpCoordinate.setPitch(player.getLocation().getPitch());
            tpCoordinate.setYaw(player.getLocation().getYaw());
            return tpCoordinate;
        }
        return null;
    }

    public static Location getElevatorLocationDown(Player player) {
        int distance = -Config.BLOCK_DISTANCE;
        for (double y = -2.0; y >= (double)distance; y -= 1.0) {
            Block block = player.getWorld().getBlockAt(player.getLocation().add(0.0, y, 0.0));
            if (block.getType() != Config.ELEVATOR_BLOCK_TYPE) continue;
            if (Mechanics.dangerBlock(block.getLocation())) {
                MessageHandler.sendAction(player, Config.ELEVATOR_LOCALE_DANGER);
                return null;
            }
            Location tpCoordinate = block.getLocation().add(0.5, 1.0, 0.5);
            tpCoordinate.setPitch(player.getLocation().getPitch());
            tpCoordinate.setYaw(player.getLocation().getYaw());
            return tpCoordinate;
        }
        return null;
    }

    public static boolean dangerBlock(Location location) {
        Material getBlock1 = location.getWorld().getBlockAt(location.add(0.0, 1.0, 0.0)).getType();
        Material getBlock2 = location.getWorld().getBlockAt(location.add(0.0, 1.0, 0.0)).getType();
        if (getBlock1.name().endsWith("SIGN") || getBlock2.name().endsWith("SIGN")) {
            return false;
        }
        return getBlock1.isSolid() || getBlock1 == Material.LAVA || getBlock2.isSolid() || getBlock2 == Material.LAVA;
    }

    public static void setParticles(Player player) {
        if (Config.PARTICLE_ENABLED && !VanishManager.isVanished(player)) {
            Location loc = player.getLocation().add(0.0, 0.5, 0.0);
            player.getWorld().spawnParticle(Config.PARTICLE_TYPE, loc, Config.PARTICLE_COUNT);
        }
    }

    public static void teleport(Player player, Location tpCoordinate) {
        player.teleport(tpCoordinate);
        player.playSound(player.getLocation(), "minecraft:" + Config.ELEVATOR_SOUND, 1.0f, 0.7f);
    }
}

