/*
 * Decompiled with CFR 0.152.
 */
package no.vestlandetmc.elevator.handler;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URLConnection;
import lombok.Generated;
import no.vestlandetmc.elevator.ElevatorPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class UpdateNotification
extends BukkitRunnable {
    private static String projectSlug;
    private static String latestVersion;

    public UpdateNotification(String projectSlug) {
        UpdateNotification.projectSlug = projectSlug;
    }

    public void run() {
        try {
            URI uri = new URI("https://api.modrinth.com/v2/project/" + projectSlug + "/version");
            URLConnection con = uri.toURL().openConnection();
            con.setRequestProperty("User-Agent", "Elevator/1.0");
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream()));){
                JsonElement element = JsonParser.parseReader((Reader)reader);
                if (!element.isJsonArray()) {
                    return;
                }
                JsonArray array = element.getAsJsonArray();
                for (JsonElement e : array) {
                    JsonObject version = e.getAsJsonObject();
                    if (!version.get("version_type").getAsString().equalsIgnoreCase("release")) continue;
                    latestVersion = version.get("version_number").getAsString();
                    break;
                }
            }
            if (UpdateNotification.isUpdateAvailable()) {
                this.onUpdateAvailable();
            }
        }
        catch (Exception e) {
            ElevatorPlugin.getPlugin().getLogger().severe(e.getMessage());
        }
    }

    public abstract void onUpdateAvailable();

    public static boolean isUpdateAvailable() {
        return !latestVersion.equals(ElevatorPlugin.getPlugin().getPluginMeta().getVersion());
    }

    public static String getCurrentVersion() {
        return ElevatorPlugin.getPlugin().getPluginMeta().getVersion();
    }

    @Generated
    public static String getProjectSlug() {
        return projectSlug;
    }

    @Generated
    public static String getLatestVersion() {
        return latestVersion;
    }

    static {
        latestVersion = "";
    }
}

