/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.attribute;

import libs.io.undertow.attribute.ExchangeAttribute;
import libs.io.undertow.attribute.ExchangeAttributeBuilder;
import libs.io.undertow.attribute.ReadOnlyAttributeException;
import libs.io.undertow.server.HttpServerExchange;
import libs.io.undertow.server.SSLSessionInfo;

public class SslCipherAttribute
implements ExchangeAttribute {
    public static final SslCipherAttribute INSTANCE = new SslCipherAttribute();

    @Override
    public String readAttribute(HttpServerExchange exchange) {
        SSLSessionInfo ssl = exchange.getConnection().getSslSessionInfo();
        if (ssl == null) {
            return null;
        }
        return ssl.getCipherSuite();
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        throw new ReadOnlyAttributeException("SSL Cipher", newValue);
    }

    public String toString() {
        return "%{SSL_CIPHER}";
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "SSL Cipher";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals("%{SSL_CIPHER}")) {
                return INSTANCE;
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

