/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.attribute;

import libs.io.undertow.attribute.ExchangeAttribute;
import libs.io.undertow.attribute.ExchangeAttributeWrapper;
import libs.io.undertow.attribute.ReadOnlyAttributeException;
import libs.io.undertow.server.HttpServerExchange;

public class SubstituteEmptyWrapper
implements ExchangeAttributeWrapper {
    private final String substitute;

    public SubstituteEmptyWrapper(String substitute) {
        this.substitute = substitute;
    }

    @Override
    public ExchangeAttribute wrap(ExchangeAttribute attribute) {
        return new SubstituteEmptyAttribute(attribute, this.substitute);
    }

    public static class SubstituteEmptyAttribute
    implements ExchangeAttribute {
        private final ExchangeAttribute attribute;
        private final String substitute;

        public SubstituteEmptyAttribute(ExchangeAttribute attribute, String substitute) {
            this.attribute = attribute;
            this.substitute = substitute;
        }

        @Override
        public String readAttribute(HttpServerExchange exchange) {
            String val = this.attribute.readAttribute(exchange);
            if (val == null || val.isEmpty()) {
                return this.substitute;
            }
            return val;
        }

        @Override
        public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
            this.attribute.writeAttribute(exchange, newValue);
        }
    }
}

