/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.io;

import java.io.Closeable;
import java.io.IOException;
import libs.io.undertow.UndertowLogger;
import libs.io.undertow.io.IoCallback;
import libs.io.undertow.io.Sender;
import libs.io.undertow.server.HttpServerExchange;
import libs.org.xnio.IoUtils;

public class DefaultIoCallback
implements IoCallback {
    private static final IoCallback CALLBACK = new IoCallback(){

        @Override
        public void onComplete(HttpServerExchange exchange, Sender sender) {
            exchange.endExchange();
        }

        @Override
        public void onException(HttpServerExchange exchange, Sender sender, IOException exception) {
            UndertowLogger.REQUEST_IO_LOGGER.ioException(exception);
            exchange.endExchange();
        }
    };

    protected DefaultIoCallback() {
    }

    @Override
    public void onComplete(HttpServerExchange exchange, Sender sender) {
        sender.close(CALLBACK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onException(HttpServerExchange exchange, Sender sender, IOException exception) {
        UndertowLogger.REQUEST_IO_LOGGER.ioException(exception);
        try {
            exchange.endExchange();
        }
        finally {
            IoUtils.safeClose((Closeable)exchange.getConnection());
        }
    }
}

