/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.predicate;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import libs.io.undertow.predicate.Predicate;
import libs.io.undertow.predicate.PredicateBuilder;
import libs.io.undertow.server.HttpServerExchange;
import libs.io.undertow.util.Headers;

@Deprecated
public class MaxContentSizePredicate
implements Predicate {
    private final long maxSize;

    MaxContentSizePredicate(long maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public boolean resolve(HttpServerExchange value) {
        String length = value.getResponseHeaders().getFirst(Headers.CONTENT_LENGTH);
        if (length == null) {
            return false;
        }
        return Long.parseLong(length) > this.maxSize;
    }

    public String toString() {
        return "max-content-size( " + this.maxSize + " )";
    }

    public static class Builder
    implements PredicateBuilder {
        @Override
        public String name() {
            return "max-content-size";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.singletonMap("value", Long.class);
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.singleton("value");
        }

        @Override
        public String defaultParameter() {
            return "value";
        }

        @Override
        public Predicate build(Map<String, Object> config) {
            Long max = (Long)config.get("value");
            return new MaxContentSizePredicate(max);
        }
    }
}

