/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.security.handlers;

import java.net.URI;
import java.net.URISyntaxException;
import libs.io.undertow.UndertowLogger;
import libs.io.undertow.server.HttpHandler;
import libs.io.undertow.server.HttpServerExchange;
import libs.io.undertow.util.Headers;

public abstract class AbstractConfidentialityHandler
implements HttpHandler {
    private final HttpHandler next;

    protected AbstractConfidentialityHandler(HttpHandler next) {
        this.next = next;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (this.isConfidential(exchange) || !this.confidentialityRequired(exchange)) {
            this.next.handleRequest(exchange);
        } else {
            try {
                URI redirectUri = this.getRedirectURI(exchange);
                UndertowLogger.SECURITY_LOGGER.debugf("Redirecting request %s to %s to meet confidentiality requirements", (Object)exchange, (Object)redirectUri);
                exchange.setStatusCode(302);
                exchange.getResponseHeaders().put(Headers.LOCATION, redirectUri.toString());
            }
            catch (Exception e) {
                UndertowLogger.REQUEST_LOGGER.exceptionProcessingRequest(e);
                exchange.setStatusCode(500);
            }
            exchange.endExchange();
        }
    }

    protected boolean isConfidential(HttpServerExchange exchange) {
        return exchange.getRequestScheme().equals("https");
    }

    protected boolean confidentialityRequired(HttpServerExchange exchange) {
        return true;
    }

    protected abstract URI getRedirectURI(HttpServerExchange var1) throws URISyntaxException;
}

