/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.security.handlers;

import java.util.Collection;
import libs.io.undertow.security.api.NotificationReceiver;
import libs.io.undertow.security.api.SecurityContext;
import libs.io.undertow.server.HttpHandler;
import libs.io.undertow.server.HttpServerExchange;

public class NotificationReceiverHandler
implements HttpHandler {
    private final HttpHandler next;
    private final NotificationReceiver[] receivers;

    public NotificationReceiverHandler(HttpHandler next, Collection<NotificationReceiver> receivers) {
        this.next = next;
        this.receivers = receivers.toArray(new NotificationReceiver[receivers.size()]);
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        SecurityContext sc = exchange.getSecurityContext();
        for (int i = 0; i < this.receivers.length; ++i) {
            sc.registerNotificationReceiver(this.receivers[i]);
        }
        this.next.handleRequest(exchange);
    }
}

