/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.server.handlers;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import libs.io.undertow.UndertowLogger;
import libs.io.undertow.server.HandlerWrapper;
import libs.io.undertow.server.HttpHandler;
import libs.io.undertow.server.HttpServerExchange;
import libs.io.undertow.server.handlers.builder.HandlerBuilder;

public class PeerNameResolvingHandler
implements HttpHandler {
    private final HttpHandler next;
    private final ResolveType resolveType;

    public PeerNameResolvingHandler(HttpHandler next) {
        this.next = next;
        this.resolveType = ResolveType.FORWARD_AND_REVERSE;
    }

    public PeerNameResolvingHandler(HttpHandler next, ResolveType resolveType) {
        this.next = next;
        this.resolveType = resolveType;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        block9: {
            InetSocketAddress address = exchange.getSourceAddress();
            if (address != null) {
                if ((this.resolveType == ResolveType.FORWARD || this.resolveType == ResolveType.FORWARD_AND_REVERSE) && address.isUnresolved()) {
                    try {
                        if (System.getSecurityManager() == null) {
                            InetSocketAddress resolvedAddress = new InetSocketAddress(InetAddress.getByName(address.getHostName()), address.getPort());
                            exchange.setSourceAddress(resolvedAddress);
                            break block9;
                        }
                        AccessController.doPrivileged(() -> {
                            InetSocketAddress resolvedAddress = new InetSocketAddress(InetAddress.getByName(address.getHostName()), address.getPort());
                            exchange.setSourceAddress(resolvedAddress);
                            return null;
                        });
                    }
                    catch (UnknownHostException e) {
                        UndertowLogger.REQUEST_LOGGER.debugf((Throwable)e, "Could not resolve hostname %s", (Object)address.getHostString());
                    }
                } else if (this.resolveType == ResolveType.REVERSE || this.resolveType == ResolveType.FORWARD_AND_REVERSE) {
                    if (System.getSecurityManager() == null) {
                        address.getHostName();
                    } else {
                        AccessController.doPrivileged(() -> {
                            address.getHostName();
                            return null;
                        });
                    }
                    exchange.setSourceAddress(address);
                }
            }
        }
        this.next.handleRequest(exchange);
    }

    public String toString() {
        return "resolve-peer-name()";
    }

    private static class Wrapper
    implements HandlerWrapper {
        private Wrapper() {
        }

        @Override
        public HttpHandler wrap(HttpHandler handler) {
            return new PeerNameResolvingHandler(handler);
        }
    }

    public static class Builder
    implements HandlerBuilder {
        @Override
        public String name() {
            return "resolve-peer-name";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.emptyMap();
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.emptySet();
        }

        @Override
        public String defaultParameter() {
            return null;
        }

        @Override
        public HandlerWrapper build(Map<String, Object> config) {
            return new Wrapper();
        }
    }

    public static enum ResolveType {
        FORWARD,
        REVERSE,
        FORWARD_AND_REVERSE;

    }
}

