/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.server.handlers;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import libs.io.undertow.conduits.StoredResponseStreamSinkConduit;
import libs.io.undertow.server.ConduitWrapper;
import libs.io.undertow.server.HandlerWrapper;
import libs.io.undertow.server.HttpHandler;
import libs.io.undertow.server.HttpServerExchange;
import libs.io.undertow.server.handlers.builder.HandlerBuilder;
import libs.io.undertow.util.ConduitFactory;
import libs.org.xnio.conduits.StreamSinkConduit;

public class StoredResponseHandler
implements HttpHandler {
    private final HttpHandler next;

    public StoredResponseHandler(HttpHandler next) {
        this.next = next;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        exchange.addResponseWrapper(new ConduitWrapper<StreamSinkConduit>(){

            @Override
            public StreamSinkConduit wrap(ConduitFactory<StreamSinkConduit> factory, HttpServerExchange exchange) {
                return new StoredResponseStreamSinkConduit(factory.create(), exchange);
            }
        });
        this.next.handleRequest(exchange);
    }

    public String toString() {
        return "store-response()";
    }

    public static class Builder
    implements HandlerBuilder {
        @Override
        public String name() {
            return "store-response";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.emptyMap();
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.emptySet();
        }

        @Override
        public String defaultParameter() {
            return null;
        }

        @Override
        public HandlerWrapper build(Map<String, Object> config) {
            return new HandlerWrapper(){

                @Override
                public HttpHandler wrap(HttpHandler handler) {
                    return new StoredResponseHandler(handler);
                }
            };
        }
    }
}

