/*
 * Decompiled with CFR 0.152.
 */
package libs.net.querz.nbt.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import libs.net.querz.io.MaxDepthIO;
import libs.net.querz.io.Serializer;
import libs.net.querz.nbt.io.LittleEndianNBTOutputStream;
import libs.net.querz.nbt.io.NBTOutputStream;
import libs.net.querz.nbt.io.NamedTag;

public class NBTSerializer
implements Serializer<NamedTag> {
    private boolean compressed;
    private boolean littleEndian;

    public NBTSerializer() {
        this(true);
    }

    public NBTSerializer(boolean compressed) {
        this.compressed = compressed;
    }

    public NBTSerializer(boolean compressed, boolean littleEndian) {
        this.compressed = compressed;
        this.littleEndian = littleEndian;
    }

    @Override
    public void toStream(NamedTag object, OutputStream out) throws IOException {
        OutputStream output = this.compressed ? new GZIPOutputStream(out, true) : out;
        MaxDepthIO nbtOut = this.littleEndian ? new LittleEndianNBTOutputStream(output) : new NBTOutputStream(output);
        nbtOut.writeTag(object, 512);
        nbtOut.flush();
    }
}

