/*
 * Decompiled with CFR 0.152.
 */
package libs.org.jboss.threads;

import io.smallrye.common.constraint.Assert;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import libs.org.jboss.logging.Logger;
import libs.org.jboss.threads.ContextClassLoaderSavingRunnable;
import libs.org.jboss.threads.DelegatingExecutor;
import libs.org.jboss.threads.DelegatingExecutorService;
import libs.org.jboss.threads.DelegatingScheduledExecutorService;
import libs.org.jboss.threads.DiscardingExecutor;
import libs.org.jboss.threads.HandoffRejectedExecutionHandler;
import libs.org.jboss.threads.LoggingUncaughtExceptionHandler;
import libs.org.jboss.threads.NullRunnable;
import libs.org.jboss.threads.RejectingExecutor;
import libs.org.jboss.threads.SimpleDirectExecutor;
import libs.org.jboss.threads.ThreadLocalResettingRunnable;
import sun.misc.Unsafe;

public final class JBossExecutors {
    private static final Logger THREAD_ERROR_LOGGER = Logger.getLogger("libs.org.jboss.threads.errors");
    private static final RuntimePermission COPY_CONTEXT_CLASSLOADER_PERMISSION = new RuntimePermission("copyClassLoader");
    private static final ExecutorService REJECTING_EXECUTOR_SERVICE = new DelegatingExecutorService(RejectingExecutor.INSTANCE);
    private static final ExecutorService DISCARDING_EXECUTOR_SERVICE = new DelegatingExecutorService(DiscardingExecutor.INSTANCE);
    private static final RejectedExecutionHandler ABORT_POLICY = new ThreadPoolExecutor.AbortPolicy();
    private static final RejectedExecutionHandler CALLER_RUNS_POLICY = new ThreadPoolExecutor.CallerRunsPolicy();
    private static final RejectedExecutionHandler DISCARD_OLDEST_POLICY = new ThreadPoolExecutor.DiscardOldestPolicy();
    private static final RejectedExecutionHandler DISCARD_POLICY = new ThreadPoolExecutor.DiscardPolicy();
    private static final Runnable TCCL_RESETTER = new Runnable(){

        @Override
        public void run() {
            Thread.currentThread().setContextClassLoader(null);
        }

        public String toString() {
            return "ContextClassLoader-resetting Runnable";
        }
    };
    private static final Runnable NULL_RUNNABLE = NullRunnable.getInstance();
    static final ClassLoader SAFE_CL;
    static final Unsafe unsafe;
    static final long contextClassLoaderOffs;
    private static final Thread.UncaughtExceptionHandler LOGGING_HANDLER;

    private JBossExecutors() {
    }

    public static Executor directExecutor() {
        return SimpleDirectExecutor.INSTANCE;
    }

    public static Executor rejectingExecutor() {
        return RejectingExecutor.INSTANCE;
    }

    public static Executor rejectingExecutor(String message) {
        return new RejectingExecutor(message);
    }

    public static ExecutorService rejectingExecutorService() {
        return REJECTING_EXECUTOR_SERVICE;
    }

    public static ExecutorService rejectingExecutorService(String message) {
        return JBossExecutors.protectedExecutorService(JBossExecutors.rejectingExecutor(message));
    }

    public static Executor discardingExecutor() {
        return DiscardingExecutor.INSTANCE;
    }

    public static ExecutorService discardingExecutorService() {
        return DISCARDING_EXECUTOR_SERVICE;
    }

    public static Executor contextClassLoaderExecutor(Executor delegate, final ClassLoader taskClassLoader) {
        return new DelegatingExecutor(delegate){

            @Override
            public void execute(Runnable command) {
                super.execute(new ContextClassLoaderSavingRunnable(taskClassLoader, command));
            }
        };
    }

    public static RejectedExecutionHandler abortPolicy() {
        return ABORT_POLICY;
    }

    public static RejectedExecutionHandler callerRunsPolicy() {
        return CALLER_RUNS_POLICY;
    }

    public static RejectedExecutionHandler discardOldestPolicy() {
        return DISCARD_OLDEST_POLICY;
    }

    public static RejectedExecutionHandler discardPolicy() {
        return DISCARD_POLICY;
    }

    public static RejectedExecutionHandler handoffPolicy(Executor target) {
        return new HandoffRejectedExecutionHandler(target);
    }

    public static ExecutorService protectedExecutorService(Executor target) {
        return new DelegatingExecutorService(target);
    }

    public static ScheduledExecutorService protectedScheduledExecutorService(ScheduledExecutorService target) {
        return new DelegatingScheduledExecutorService(target);
    }

    public static ThreadFactory resettingThreadFactory(final ThreadFactory delegate) throws SecurityException {
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return delegate.newThread(new ThreadLocalResettingRunnable(r));
            }
        };
    }

    public static Runnable nullRunnable() {
        return NULL_RUNNABLE;
    }

    public static Runnable contextClassLoaderResetter() {
        return TCCL_RESETTER;
    }

    public static Runnable classLoaderPreservingTask(Runnable delegate) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(COPY_CONTEXT_CLASSLOADER_PERMISSION);
        }
        return JBossExecutors.classLoaderPreservingTaskUnchecked(delegate);
    }

    static Runnable classLoaderPreservingTaskUnchecked(Runnable delegate) {
        Assert.checkNotNullParam("delegate", delegate);
        return new ContextClassLoaderSavingRunnable(JBossExecutors.getContextClassLoader(Thread.currentThread()), delegate);
    }

    static ClassLoader getContextClassLoader(Thread thread) {
        return (ClassLoader)unsafe.getObject(thread, contextClassLoaderOffs);
    }

    static ClassLoader getAndSetContextClassLoader(Thread thread, ClassLoader newClassLoader) {
        ClassLoader currentClassLoader = (ClassLoader)unsafe.getObject(thread, contextClassLoaderOffs);
        if (currentClassLoader != newClassLoader) {
            unsafe.putObject(thread, contextClassLoaderOffs, newClassLoader);
        }
        return currentClassLoader;
    }

    static void setContextClassLoader(Thread thread, ClassLoader classLoader) {
        if (unsafe.getObject(thread, contextClassLoaderOffs) != classLoader) {
            unsafe.putObject(thread, contextClassLoaderOffs, classLoader);
        }
    }

    static void clearContextClassLoader(Thread thread) {
        unsafe.putObject(thread, contextClassLoaderOffs, SAFE_CL);
    }

    public static Thread.UncaughtExceptionHandler loggingExceptionHandler(Logger log) {
        return new LoggingUncaughtExceptionHandler(log);
    }

    public static Thread.UncaughtExceptionHandler loggingExceptionHandler(String categoryName) {
        return new LoggingUncaughtExceptionHandler(Logger.getLogger(categoryName));
    }

    public static Thread.UncaughtExceptionHandler loggingExceptionHandler() {
        return LOGGING_HANDLER;
    }

    static {
        ClassLoader safeClassLoader = JBossExecutors.class.getClassLoader();
        if (safeClassLoader == null) {
            safeClassLoader = ClassLoader.getSystemClassLoader();
        }
        if (safeClassLoader == null) {
            safeClassLoader = new ClassLoader(){};
        }
        SAFE_CL = safeClassLoader;
        unsafe = AccessController.doPrivileged(new PrivilegedAction<Unsafe>(){

            @Override
            public Unsafe run() {
                try {
                    Field field = Unsafe.class.getDeclaredField("theUnsafe");
                    field.setAccessible(true);
                    return (Unsafe)field.get(null);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalAccessError(e.getMessage());
                }
                catch (NoSuchFieldException e) {
                    throw new NoSuchFieldError(e.getMessage());
                }
            }
        });
        try {
            contextClassLoaderOffs = unsafe.objectFieldOffset(Thread.class.getDeclaredField("contextClassLoader"));
        }
        catch (NoSuchFieldException e) {
            throw new NoSuchFieldError(e.getMessage());
        }
        LOGGING_HANDLER = JBossExecutors.loggingExceptionHandler(THREAD_ERROR_LOGGER);
    }
}

