/*
 * Decompiled with CFR 0.152.
 */
package libs.org.simpleyaml.configuration.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import libs.org.simpleyaml.configuration.Configuration;
import libs.org.simpleyaml.configuration.ConfigurationSection;
import libs.org.simpleyaml.configuration.comments.format.YamlHeaderFormatter;
import libs.org.simpleyaml.configuration.file.FileConfiguration;
import libs.org.simpleyaml.configuration.file.YamlConfigurationOptions;
import libs.org.simpleyaml.configuration.implementation.api.QuoteStyle;
import libs.org.simpleyaml.configuration.implementation.api.QuoteValue;
import libs.org.simpleyaml.configuration.implementation.api.YamlImplementation;
import libs.org.simpleyaml.configuration.implementation.snakeyaml.SnakeYamlImplementation;
import libs.org.simpleyaml.exceptions.InvalidConfigurationException;
import libs.org.simpleyaml.utils.StringUtils;
import libs.org.simpleyaml.utils.SupplierIO;
import libs.org.simpleyaml.utils.Validate;

public class YamlConfiguration
extends FileConfiguration {
    protected YamlImplementation yamlImplementation;

    public YamlConfiguration() {
        this((Configuration)null);
    }

    public YamlConfiguration(Configuration defaults) {
        this(defaults, new SnakeYamlImplementation());
    }

    public YamlConfiguration(YamlImplementation yamlImplementation) {
        this(null, yamlImplementation);
    }

    public YamlConfiguration(Configuration defaults, YamlImplementation yamlImplementation) {
        super(defaults);
        this.setImplementation(yamlImplementation);
    }

    public YamlImplementation getImplementation() {
        return this.yamlImplementation;
    }

    public void setImplementation(YamlImplementation yamlImplementation) {
        Validate.notNull(yamlImplementation, "YAML implementation cannot be null!");
        this.yamlImplementation = yamlImplementation;
        this.yamlImplementation.configure(this.options());
    }

    @Override
    public String saveToString() throws IOException {
        StringWriter stringWriter = new StringWriter();
        this.save(stringWriter);
        return StringUtils.stripCarriage(stringWriter.toString());
    }

    @Override
    public void save(Writer writer) throws IOException {
        Validate.notNull(writer, "Writer cannot be null");
        try {
            writer.write(this.buildHeader());
            this.dump(writer);
        }
        finally {
            writer.close();
        }
    }

    public String dump() throws IOException {
        return this.yamlImplementation.dump(this);
    }

    public void dump(Writer writer) throws IOException {
        Validate.notNull(writer, "Writer cannot be null");
        this.yamlImplementation.dump(writer, this);
    }

    public void load(SupplierIO.Reader readerSupplier) throws IOException, InvalidConfigurationException {
        Validate.notNull(readerSupplier, "Reader supplier cannot be null");
        this.loadHeader((Reader)readerSupplier.get());
        this.yamlImplementation.load(readerSupplier, (ConfigurationSection)this);
    }

    protected void loadHeader(Reader reader) throws IOException {
        YamlConfigurationOptions options = this.options();
        YamlHeaderFormatter headerFormatter = options.headerFormatter();
        boolean customStripPrefix = headerFormatter.stripPrefix();
        headerFormatter.stripPrefix(false);
        options.header(headerFormatter.parse(reader));
        headerFormatter.stripPrefix(customStripPrefix);
    }

    public static YamlConfiguration loadConfiguration(SupplierIO.Reader readerSupplier) throws IOException {
        Validate.notNull(readerSupplier, "Reader supplier cannot be null");
        return YamlConfiguration.load(config -> config.load(readerSupplier));
    }

    public static YamlConfiguration loadConfiguration(File file) throws IOException {
        Validate.notNull(file, "File cannot be null");
        return YamlConfiguration.load(config -> config.load(file));
    }

    @Override
    public void load(File file) throws FileNotFoundException, IOException, InvalidConfigurationException {
        Validate.notNull(file, "File cannot be null");
        this.load(() -> Files.newInputStream(file.toPath(), new OpenOption[0]));
    }

    public static YamlConfiguration loadConfigurationFromString(String contents) throws IOException {
        return YamlConfiguration.load(config -> config.loadFromString(contents));
    }

    @Override
    public void loadFromString(String contents) throws IOException {
        Validate.notNull(contents, "Contents cannot be null");
        this.load(() -> new StringReader(contents));
    }

    public static YamlConfiguration loadConfiguration(SupplierIO.InputStream streamSupplier) throws IOException {
        Validate.notNull(streamSupplier, "Reader supplier cannot be null");
        return YamlConfiguration.load(config -> config.load(streamSupplier));
    }

    public void load(SupplierIO.InputStream streamSupplier) throws IOException, InvalidConfigurationException {
        Validate.notNull(streamSupplier, "Stream supplier cannot be null");
        this.load(() -> new InputStreamReader((InputStream)streamSupplier.get(), this.options().charset()));
    }

    @Deprecated
    public static YamlConfiguration loadConfiguration(InputStream stream) throws IOException {
        Validate.notNull(stream, "Stream cannot be null");
        return YamlConfiguration.load(config -> config.load(stream));
    }

    @Override
    @Deprecated
    public void load(InputStream stream) throws IOException, InvalidConfigurationException {
        super.load(stream);
    }

    @Deprecated
    public static YamlConfiguration loadConfiguration(Reader reader) throws IOException {
        Validate.notNull(reader, "Reader cannot be null");
        return YamlConfiguration.load(config -> config.load(reader));
    }

    @Override
    @Deprecated
    public void load(Reader reader) throws IOException, InvalidConfigurationException {
        super.load(reader);
    }

    public void set(String path, Object value, QuoteStyle quoteStyle) {
        this.set(path, new QuoteValue<Object>(value, quoteStyle));
    }

    @Override
    public void set(String path, Object value) {
        QuoteStyle quoteStyle;
        if (value != null && !(value instanceof QuoteValue) && (quoteStyle = this.options().quoteStyleDefaults().getExplicitQuoteStyleInstanceOf(value.getClass())) != null) {
            this.set(path, value, quoteStyle);
            return;
        }
        super.set(path, value);
    }

    @Override
    public Object get(String path, Object def) {
        Object object = super.get(path, def);
        if (object instanceof QuoteValue) {
            object = ((QuoteValue)object).getValue();
        }
        return object;
    }

    @Override
    public YamlConfigurationOptions options() {
        if (this.options == null) {
            this.options = new YamlConfigurationOptions(this);
        }
        return (YamlConfigurationOptions)this.options;
    }

    private static YamlConfiguration load(YamlConfigurationLoader loader) throws IOException {
        YamlConfiguration config = new YamlConfiguration();
        loader.load(config);
        return config;
    }

    @FunctionalInterface
    private static interface YamlConfigurationLoader {
        public void load(YamlConfiguration var1) throws IOException;
    }
}

