/*
 * Decompiled with CFR 0.152.
 */
package libs.org.wildfly.common.array;

import java.lang.reflect.Array;
import java.util.Arrays;

public final class Arrays2 {
    private Arrays2() {
    }

    public static boolean equals(byte[] a1, int offs1, byte[] a2, int offs2, int len) {
        if (offs1 < 0 || offs1 + len > a1.length) {
            return false;
        }
        if (offs2 < 0 || offs2 + len > a2.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (a1[i + offs1] == a2[i + offs2]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(byte[] a1, int offs1, byte[] a2) {
        return Arrays2.equals(a1, offs1, a2, 0, a2.length);
    }

    public static boolean equals(char[] a1, int offs1, char[] a2, int offs2, int len) {
        if (offs1 + len > a1.length) {
            return false;
        }
        if (offs2 + len > a2.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (a1[i + offs1] == a2[i + offs2]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(char[] a1, int offs1, char[] a2) {
        return Arrays2.equals(a1, offs1, a2, 0, a2.length);
    }

    public static boolean equals(char[] a1, int offs1, String a2, int offs2, int len) {
        if (offs1 + len > a1.length) {
            return false;
        }
        if (offs2 + len > a2.length()) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (a1[i + offs1] == a2.charAt(i + offs2)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(char[] a1, int offs1, String a2) {
        return Arrays2.equals(a1, offs1, a2, 0, a2.length());
    }

    public static boolean equals(String a1, int offs1, char[] a2) {
        return Arrays2.equals(a2, 0, a1, offs1, a2.length);
    }

    public static boolean equals(String a1, char[] a2) {
        return Arrays2.equals(a1, 0, a2);
    }

    @SafeVarargs
    public static <T> T[] of(T ... items) {
        return items;
    }

    private static char hex(int v) {
        return (char)(v < 10 ? 48 + v : 97 + v - 10);
    }

    public static String toString(byte[] bytes) {
        StringBuilder b = new StringBuilder(bytes.length * 2);
        for (byte x : bytes) {
            b.append(Arrays2.hex((x & 0xF0) >> 4)).append(Arrays2.hex(x & 0xF));
        }
        return b.toString();
    }

    public static int indexOf(byte[] array, int search, int offs, int len) {
        for (int i = 0; i < len; ++i) {
            if (array[offs + i] != (byte)search) continue;
            return offs + i;
        }
        return -1;
    }

    public static int indexOf(byte[] array, int search, int offs) {
        return Arrays2.indexOf(array, search, offs, array.length - offs);
    }

    public static int indexOf(byte[] array, int search) {
        return Arrays2.indexOf(array, search, 0, array.length);
    }

    public static <E> E[] createArray(Class<E> elementType, int size) {
        return (Object[])Array.newInstance(elementType, size);
    }

    public static <E> E[] compactNulls(E[] original) {
        E item;
        int r = 0;
        while ((item = original[r++]) != null) {
            if (r != original.length) continue;
            return original;
        }
        int w = r - 1;
        do {
            if ((item = original[r++]) == null) continue;
            original[w++] = item;
        } while (r != original.length);
        return Arrays.copyOf(original, w);
    }

    public static String objectToString(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof Object[]) {
            return Arrays.deepToString((Object[])value);
        }
        if (value.getClass().isArray()) {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            for (int i = 0; i < Array.getLength(value); ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(String.valueOf(Array.get(value, i)));
            }
            sb.append(']');
            return sb.toString();
        }
        return value.toString();
    }
}

