/*
 * Decompiled with CFR 0.152.
 */
package libs.org.wildfly.common.bytes;

import java.security.DigestException;
import java.security.MessageDigest;
import java.util.Arrays;
import javax.crypto.Mac;
import libs.org.wildfly.common._private.CommonMessages;
import libs.org.wildfly.common.iteration.ByteIterator;
import libs.org.wildfly.common.iteration.CodePointIterator;

public final class ByteStringBuilder {
    private byte[] content;
    private int length;

    public ByteStringBuilder() {
        this.content = new byte[16];
    }

    public ByteStringBuilder(byte[] content) {
        if (content != null && content.length != 0) {
            this.content = (byte[])content.clone();
            this.length = this.content.length;
        } else {
            this.content = new byte[16];
        }
    }

    public ByteStringBuilder append(boolean b) {
        this.appendLatin1(Boolean.toString(b));
        return this;
    }

    public ByteStringBuilder append(byte b) {
        this.doAppend(b);
        return this;
    }

    public ByteStringBuilder append(char c) {
        return this.appendUtf8Raw(c);
    }

    public ByteStringBuilder appendUtf8Raw(int codePoint) {
        if (codePoint < 0) {
            throw new IllegalArgumentException();
        }
        if (codePoint < 128) {
            this.doAppend((byte)codePoint);
        } else if (codePoint < 2048) {
            this.doAppend((byte)(0xC0 | 0x1F & codePoint >>> 6));
            this.doAppend((byte)(0x80 | 0x3F & codePoint));
        } else if (codePoint < 65536) {
            this.doAppend((byte)(0xE0 | 0xF & codePoint >>> 12));
            this.doAppend((byte)(0x80 | 0x3F & codePoint >>> 6));
            this.doAppend((byte)(0x80 | 0x3F & codePoint));
        } else if (codePoint < 0x110000) {
            this.doAppend((byte)(0xF0 | 7 & codePoint >>> 18));
            this.doAppend((byte)(0x80 | 0x3F & codePoint >>> 12));
            this.doAppend((byte)(0x80 | 0x3F & codePoint >>> 6));
            this.doAppend((byte)(0x80 | 0x3F & codePoint));
        } else {
            throw new IllegalArgumentException();
        }
        return this;
    }

    public ByteStringBuilder appendUtf8(CodePointIterator iterator) {
        while (iterator.hasNext()) {
            this.appendUtf8Raw(iterator.next());
        }
        return this;
    }

    public ByteStringBuilder appendLatin1(CodePointIterator iterator) {
        while (iterator.hasNext()) {
            int cp = iterator.next();
            if (cp > 255) {
                throw new IllegalArgumentException();
            }
            this.append((byte)cp);
        }
        return this;
    }

    public ByteStringBuilder appendAscii(CodePointIterator iterator) {
        while (iterator.hasNext()) {
            int cp = iterator.next();
            if (cp > 127) {
                throw new IllegalArgumentException();
            }
            this.append((byte)cp);
        }
        return this;
    }

    public ByteStringBuilder append(ByteIterator iterator) {
        return iterator.appendTo(this);
    }

    public ByteStringBuilder append(byte[] bytes) {
        int length = this.length;
        int bl = bytes.length;
        this.reserve(bl, false);
        System.arraycopy(bytes, 0, this.content, length, bl);
        this.length = length + bl;
        return this;
    }

    public ByteStringBuilder append(byte[] bytes, int offs, int len) {
        this.reserve(len, false);
        int length = this.length;
        System.arraycopy(bytes, offs, this.content, length, len);
        this.length = length + len;
        return this;
    }

    public ByteStringBuilder appendLatin1(CharSequence s) {
        int len = s.length();
        this.reserve(len, false);
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c > '\u00ff') {
                throw new IllegalArgumentException();
            }
            this.doAppendNoCheck((byte)c);
        }
        return this;
    }

    public ByteStringBuilder appendLatin1(CharSequence s, int offs, int len) {
        this.reserve(len, false);
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i + offs);
            if (c > '\u00ff') {
                throw new IllegalArgumentException();
            }
            this.doAppendNoCheck((byte)c);
        }
        return this;
    }

    public ByteStringBuilder appendLatin1(String s) {
        int len = s.length();
        this.reserve(len, false);
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c > '\u00ff') {
                throw new IllegalArgumentException();
            }
            this.doAppendNoCheck((byte)c);
        }
        return this;
    }

    public ByteStringBuilder appendLatin1(String s, int offs, int len) {
        this.reserve(len, false);
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i + offs);
            if (c > '\u00ff') {
                throw new IllegalArgumentException();
            }
            this.doAppendNoCheck((byte)c);
        }
        return this;
    }

    public ByteStringBuilder append(CharSequence s) {
        return this.append(s, 0, s.length());
    }

    public ByteStringBuilder append(CharSequence s, int offs, int len) {
        int i = 0;
        while (i < len) {
            int c;
            if (Character.isHighSurrogate((char)(c = s.charAt(offs + i++)))) {
                if (i < len) {
                    char t;
                    if (!Character.isLowSurrogate(t = s.charAt(offs + i++))) {
                        throw new IllegalArgumentException();
                    }
                    c = Character.toCodePoint((char)c, t);
                } else {
                    throw new IllegalArgumentException();
                }
            }
            this.appendUtf8Raw(c);
        }
        return this;
    }

    public ByteStringBuilder append(String s) {
        return this.append(s, 0, s.length());
    }

    public ByteStringBuilder append(String s, int offs, int len) {
        int i = 0;
        while (i < len) {
            int c;
            if (Character.isHighSurrogate((char)(c = s.charAt(offs + i++)))) {
                if (i < len) {
                    char t;
                    if (!Character.isLowSurrogate(t = s.charAt(offs + i++))) {
                        throw new IllegalArgumentException();
                    }
                    c = Character.toCodePoint((char)c, t);
                } else {
                    throw new IllegalArgumentException();
                }
            }
            this.appendUtf8Raw(c);
        }
        return this;
    }

    public ByteStringBuilder appendPackedUnsignedBE(int v) {
        if (v > 0) {
            int bits = Integer.numberOfTrailingZeros(Integer.highestOneBit(v)) + 1;
            int size = (bits + 7) / 7;
            int x = 0;
            int b = (size - 1) * 7;
            while (x < size - 1) {
                this.doAppend((byte)(0x80 | v >>> b));
                ++x;
                b -= 7;
            }
        }
        this.doAppend((byte)(0xFFFFFF7F & v));
        return this;
    }

    public ByteStringBuilder appendPackedUnsignedBE(long v) {
        if (v > 0L) {
            int bits = Long.numberOfTrailingZeros(Long.highestOneBit(v)) + 1;
            int size = (bits + 7) / 7;
            int x = 0;
            int b = (size - 1) * 7;
            while (x < size - 1) {
                this.doAppend((byte)(0x80L | v >>> b));
                ++x;
                b -= 7;
            }
        }
        this.doAppend((byte)(0xFFFFFFFFFFFFFF7FL & v));
        return this;
    }

    public ByteStringBuilder appendBE(short s) {
        this.doAppend((byte)(s >>> 8));
        this.doAppend((byte)s);
        return this;
    }

    public ByteStringBuilder appendNumber(int i) {
        this.appendLatin1(Integer.toString(i));
        return this;
    }

    public ByteStringBuilder appendBE(int i) {
        this.doAppend((byte)(i >>> 24));
        this.doAppend((byte)(i >>> 16));
        this.doAppend((byte)(i >>> 8));
        this.doAppend((byte)i);
        return this;
    }

    public ByteStringBuilder appendNumber(long l) {
        this.appendLatin1(Long.toString(l));
        return this;
    }

    public ByteStringBuilder appendBE(long l) {
        this.doAppend((byte)(l >>> 56));
        this.doAppend((byte)(l >>> 48));
        this.doAppend((byte)(l >>> 40));
        this.doAppend((byte)(l >>> 32));
        this.doAppend((byte)(l >>> 24));
        this.doAppend((byte)(l >>> 16));
        this.doAppend((byte)(l >>> 8));
        this.doAppend((byte)l);
        return this;
    }

    public ByteStringBuilder appendObject(Object o) {
        this.appendLatin1(String.valueOf(o));
        return this;
    }

    public ByteStringBuilder append(ByteStringBuilder other) {
        this.append(other.content, 0, other.length);
        return this;
    }

    public ByteStringBuilder updateDigest(MessageDigest messageDigest) {
        messageDigest.update(this.content, 0, this.length);
        return this;
    }

    public ByteStringBuilder appendDigestResult(MessageDigest messageDigest) throws DigestException {
        this.reserve(messageDigest.getDigestLength(), false);
        int length = this.length;
        byte[] content = this.content;
        this.length = length + messageDigest.digest(content, length, content.length - length);
        return this;
    }

    public ByteStringBuilder updateMac(Mac mac) {
        mac.update(this.content, 0, this.length);
        return this;
    }

    public byte[] toArray() {
        return Arrays.copyOf(this.content, this.length);
    }

    public byte byteAt(int index) {
        if (index < 0 || index > this.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.content[index];
    }

    public int capacity() {
        return this.content.length;
    }

    public int length() {
        return this.length;
    }

    public void setLength(int newLength) {
        if (newLength > this.length) {
            this.reserve(newLength - this.length, true);
        }
        this.length = newLength;
    }

    public boolean contentEquals(byte[] other) {
        return this.contentEquals(other, 0, other.length);
    }

    public boolean contentEquals(byte[] other, int offs, int length) {
        if (length != this.length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (this.content[i] == other[offs + i]) continue;
            return false;
        }
        return true;
    }

    private void reserve(int count, boolean clear) {
        byte[] content = this.content;
        int cl = content.length;
        int length = this.length;
        if (cl - length >= count) {
            if (clear) {
                Arrays.fill(content, length, length + count, (byte)0);
            }
            return;
        }
        if (clear) {
            Arrays.fill(content, length, cl, (byte)0);
        }
        do {
            if ((cl += cl + 1 >> 1) >= 0) continue;
            throw CommonMessages.msg.tooLarge();
        } while (cl - length < count);
        this.content = Arrays.copyOf(content, cl);
    }

    private void doAppend(byte b) {
        int length = this.length;
        byte[] content = this.content;
        int cl = content.length;
        if (length == cl) {
            content = this.content = Arrays.copyOf(content, cl + (cl + 1 >> 1));
        }
        content[length] = b;
        this.length = length + 1;
    }

    private void doAppendNoCheck(byte b) {
        this.content[this.length++] = b;
    }

    public ByteIterator iterate() {
        return ByteIterator.ofBytes(this.content, 0, this.length);
    }
}

