/*
 * Decompiled with CFR 0.152.
 */
package libs.org.wildfly.common.function;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.DoubleFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.LongFunction;
import java.util.function.ObjDoubleConsumer;
import java.util.function.ObjIntConsumer;
import java.util.function.ObjLongConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleBiFunction;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntBiFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongBiFunction;
import java.util.function.ToLongFunction;
import libs.org.jboss.logging.Logger;
import libs.org.wildfly.common.Assert;
import libs.org.wildfly.common.function.ExceptionBiConsumer;
import libs.org.wildfly.common.function.ExceptionBiFunction;
import libs.org.wildfly.common.function.ExceptionBiPredicate;
import libs.org.wildfly.common.function.ExceptionConsumer;
import libs.org.wildfly.common.function.ExceptionFunction;
import libs.org.wildfly.common.function.ExceptionIntFunction;
import libs.org.wildfly.common.function.ExceptionLongFunction;
import libs.org.wildfly.common.function.ExceptionObjIntConsumer;
import libs.org.wildfly.common.function.ExceptionObjLongConsumer;
import libs.org.wildfly.common.function.ExceptionPredicate;
import libs.org.wildfly.common.function.ExceptionRunnable;
import libs.org.wildfly.common.function.ExceptionSupplier;
import libs.org.wildfly.common.function.ExceptionToIntBiFunction;
import libs.org.wildfly.common.function.ExceptionToIntFunction;
import libs.org.wildfly.common.function.ExceptionToLongBiFunction;
import libs.org.wildfly.common.function.ExceptionToLongFunction;

public final class Functions {
    private static final Logger LOGGER = Logger.getLogger(Functions.class);
    private static final Consumer<AutoCloseable> CLOSING_CONSUMER = Functions.quiet(AutoCloseable::close, Functions.exceptionLoggingConsumer());
    private static final Consumer<Exception> EXCEPTION_LOGGER = new Consumer<Exception>(){

        @Override
        public void accept(Exception e) {
            LOGGER.warn((Object)e.getLocalizedMessage(), e);
        }
    };

    private Functions() {
    }

    public static <T extends AutoCloseable> Consumer<T> closingConsumer() {
        return CLOSING_CONSUMER;
    }

    public static <E extends Exception> Consumer<E> exceptionLoggingConsumer() {
        return EXCEPTION_LOGGER;
    }

    public static <E extends Exception, RE extends RuntimeException> Consumer<E> runtimeExceptionThrowingConsumer(final Function<E, RE> runtimeExceptionWrapper) {
        return new Consumer<E>(){

            @Override
            public void accept(E exception) {
                throw (RuntimeException)runtimeExceptionWrapper.apply(exception);
            }
        };
    }

    public static <T, E extends Exception> Consumer<T> quiet(final ExceptionConsumer<T, E> consumer, final Consumer<E> exceptionHandler) {
        return new Consumer<T>(){

            @Override
            public void accept(T value) {
                try {
                    consumer.accept(value);
                }
                catch (Exception e) {
                    exceptionHandler.accept(e);
                }
            }
        };
    }

    public static <T, U, E extends Exception> BiConsumer<T, U> quiet(final ExceptionBiConsumer<T, U, E> consumer, final Consumer<E> exceptionHandler) {
        return new BiConsumer<T, U>(){

            @Override
            public void accept(T value1, U value2) {
                try {
                    consumer.accept(value1, value2);
                }
                catch (Exception e) {
                    exceptionHandler.accept(e);
                }
            }
        };
    }

    public static <T, E extends Exception> ObjIntConsumer<T> quiet(final ExceptionObjIntConsumer<T, E> consumer, final Consumer<E> exceptionHandler) {
        return new ObjIntConsumer<T>(){

            @Override
            public void accept(T object, int i) {
                try {
                    consumer.accept(object, i);
                }
                catch (Exception e) {
                    exceptionHandler.accept(e);
                }
            }
        };
    }

    public static <T, E extends Exception> ObjLongConsumer<T> quiet(final ExceptionObjLongConsumer<T, E> consumer, final Consumer<E> exceptionHandler) {
        return new ObjLongConsumer<T>(){

            @Override
            public void accept(T object, long i) {
                try {
                    consumer.accept(object, i);
                }
                catch (Exception e) {
                    exceptionHandler.accept(e);
                }
            }
        };
    }

    public static Consumer<Runnable> runnableConsumer() {
        return RunnableConsumer.INSTANCE;
    }

    public static <E extends Exception> ExceptionConsumer<ExceptionRunnable<E>, E> exceptionRunnableConsumer() {
        return ExceptionRunnableConsumer.INSTANCE;
    }

    public static ExceptionConsumer<Runnable, RuntimeException> runnableExceptionConsumer() {
        return RunnableExceptionConsumer.INSTANCE;
    }

    public static <T> BiConsumer<Consumer<T>, T> consumerBiConsumer() {
        return ConsumerBiConsumer.INSTANCE;
    }

    public static <T, E extends Exception> ExceptionBiConsumer<ExceptionConsumer<T, E>, T, E> exceptionConsumerBiConsumer() {
        return ExceptionConsumerBiConsumer.INSTANCE;
    }

    public static <T> ExceptionBiConsumer<Consumer<T>, T, RuntimeException> consumerExceptionBiConsumer() {
        return ConsumerExceptionBiConsumer.INSTANCE;
    }

    public static <R> Function<Supplier<R>, R> supplierFunction() {
        return SupplierFunction.INSTANCE;
    }

    public static <R, E extends Exception> ExceptionFunction<ExceptionSupplier<R, E>, R, E> exceptionSupplierFunction() {
        return ExceptionSupplierFunction.INSTANCE;
    }

    public static <R> ExceptionFunction<Supplier<R>, R, RuntimeException> supplierExceptionFunction() {
        return SupplierExceptionFunction.INSTANCE;
    }

    public static <R> BiFunction<Function<Supplier<R>, R>, Supplier<R>, R> supplierFunctionBiFunction() {
        return FunctionSupplierBiFunction.INSTANCE;
    }

    public static <R, E extends Exception> ExceptionBiFunction<ExceptionFunction<ExceptionSupplier<R, E>, R, E>, ExceptionSupplier<R, E>, R, E> exceptionSupplierFunctionBiFunction() {
        return ExceptionFunctionSupplierBiFunction.INSTANCE;
    }

    public static <T, R> BiFunction<Function<T, R>, T, R> functionBiFunction() {
        return FunctionBiFunction.INSTANCE;
    }

    public static <T, R, E extends Exception> ExceptionBiFunction<ExceptionFunction<T, R, E>, T, R, E> exceptionFunctionBiFunction() {
        return ExceptionFunctionBiFunction.INSTANCE;
    }

    public static <T, R> ExceptionBiFunction<Function<T, R>, T, R, RuntimeException> functionExceptionBiFunction() {
        return FunctionExceptionBiFunction.INSTANCE;
    }

    public static <T> Supplier<T> constantSupplier(T value) {
        return value == null ? ConstantSupplier.NULL : new ConstantSupplier<T>(value);
    }

    public static <T, E extends Exception> ExceptionSupplier<T, E> constantExceptionSupplier(T value) {
        return value == null ? ConstantSupplier.NULL : new ConstantSupplier<T>(value);
    }

    public static <T, U> Runnable capturingRunnable(BiConsumer<T, U> consumer, T param1, U param2) {
        Assert.checkNotNullParam("consumer", consumer);
        return new BiConsumerRunnable<T, U>(consumer, param1, param2);
    }

    public static <T> Runnable capturingRunnable(Consumer<T> consumer, T param) {
        Assert.checkNotNullParam("consumer", consumer);
        return new ConsumerRunnable<T>(consumer, param);
    }

    public static <T, U, E extends Exception> ExceptionRunnable<E> exceptionCapturingRunnable(ExceptionBiConsumer<T, U, E> consumer, T param1, U param2) {
        Assert.checkNotNullParam("consumer", consumer);
        return new ExceptionBiConsumerRunnable<T, U, E>(consumer, param1, param2);
    }

    public static <T, E extends Exception> ExceptionRunnable<E> exceptionCapturingRunnable(ExceptionConsumer<T, E> consumer, T param) {
        Assert.checkNotNullParam("consumer", consumer);
        return new ExceptionConsumerRunnable<T, E>(consumer, param);
    }

    public static <T> Consumer<T> discardingConsumer() {
        return DiscardingConsumer.INSTANCE;
    }

    public static <T, E extends Exception> ExceptionConsumer<T, E> discardingExceptionConsumer() {
        return DiscardingConsumer.INSTANCE;
    }

    public static <T, U> BiConsumer<T, U> discardingBiConsumer() {
        return DiscardingBiConsumer.INSTANCE;
    }

    public static <T, U, E extends Exception> ExceptionBiConsumer<T, U, E> discardingExceptionBiConsumer() {
        return DiscardingBiConsumer.INSTANCE;
    }

    public static <T, TT extends T> Consumer<TT> cast(Consumer<T> consumer) {
        return consumer;
    }

    public static <T, TT extends T> Predicate<TT> cast(Predicate<T> predicate) {
        return predicate;
    }

    public static <T extends TT, TT> Supplier<TT> cast(Supplier<T> supplier) {
        return supplier;
    }

    public static <T, R extends RR, TT extends T, RR> Function<TT, RR> cast(Function<T, R> function) {
        return function;
    }

    public static <R extends RR, RR> DoubleFunction<RR> cast(DoubleFunction<R> function) {
        return function;
    }

    public static <R extends RR, RR> IntFunction<RR> cast(IntFunction<R> function) {
        return function;
    }

    public static <R extends RR, RR> LongFunction<RR> cast(LongFunction<R> function) {
        return function;
    }

    public static <T, TT extends T> ToDoubleFunction<TT> cast(ToDoubleFunction<T> function) {
        return function;
    }

    public static <T, TT extends T> ToIntFunction<TT> cast(ToIntFunction<T> function) {
        return function;
    }

    public static <T, TT extends T> ToLongFunction<TT> cast(ToLongFunction<T> function) {
        return function;
    }

    public static <T, U, TT extends T, UU extends U> BiConsumer<TT, UU> cast(BiConsumer<T, U> consumer) {
        return consumer;
    }

    public static <T, TT extends T> ObjDoubleConsumer<TT> cast(ObjDoubleConsumer<T> consumer) {
        return consumer;
    }

    public static <T, TT extends T> ObjIntConsumer<TT> cast(ObjIntConsumer<T> consumer) {
        return consumer;
    }

    public static <T, TT extends T> ObjLongConsumer<TT> cast(ObjLongConsumer<T> consumer) {
        return consumer;
    }

    public static <T, U, TT extends T, UU extends U> BiPredicate<TT, UU> cast(BiPredicate<T, U> predicate) {
        return predicate;
    }

    public static <T, U, R extends RR, TT extends T, UU extends U, RR> BiFunction<TT, UU, RR> cast(BiFunction<T, U, R> function) {
        return function;
    }

    public static <T, U, TT extends T, UU extends U> ToDoubleBiFunction<TT, UU> cast(ToDoubleBiFunction<T, U> function) {
        return function;
    }

    public static <T, U, TT extends T, UU extends U> ToIntBiFunction<TT, UU> cast(ToIntBiFunction<T, U> function) {
        return function;
    }

    public static <T, U, TT extends T, UU extends U> ToLongBiFunction<TT, UU> cast(ToLongBiFunction<T, U> function) {
        return function;
    }

    public static <T, E extends EE, TT extends T, EE extends Exception> ExceptionConsumer<TT, EE> cast(ExceptionConsumer<T, E> consumer) {
        return consumer;
    }

    public static <T, E extends EE, TT extends T, EE extends Exception> ExceptionPredicate<TT, EE> cast(ExceptionPredicate<T, E> consumer) {
        return consumer;
    }

    public static <T extends TT, E extends EE, TT, EE extends Exception> ExceptionSupplier<TT, EE> cast(ExceptionSupplier<T, E> supplier) {
        return supplier;
    }

    public static <T, R extends RR, E extends EE, TT extends T, RR, EE extends Exception> ExceptionFunction<TT, RR, EE> cast(ExceptionFunction<T, R, E> function) {
        return function;
    }

    public static <R extends RR, E extends EE, RR, EE extends Exception> ExceptionIntFunction<RR, EE> cast(ExceptionIntFunction<R, E> function) {
        return function;
    }

    public static <R extends RR, E extends EE, RR, EE extends Exception> ExceptionLongFunction<RR, EE> cast(ExceptionLongFunction<R, E> function) {
        return function;
    }

    public static <T, E extends EE, TT extends T, EE extends Exception> ExceptionToIntFunction<TT, EE> cast(ExceptionToIntFunction<T, E> function) {
        return function;
    }

    public static <T, E extends EE, TT extends T, EE extends Exception> ExceptionToLongFunction<TT, EE> cast(ExceptionToLongFunction<T, E> function) {
        return function;
    }

    public static <T, E extends EE, TT extends T, U, UU extends U, EE extends Exception> ExceptionBiConsumer<TT, UU, EE> cast(ExceptionBiConsumer<T, U, E> consumer) {
        return consumer;
    }

    public static <T, E extends EE, TT extends T, EE extends Exception> ExceptionObjIntConsumer<TT, EE> cast(ExceptionObjIntConsumer<T, E> consumer) {
        return consumer;
    }

    public static <T, E extends EE, TT extends T, EE extends Exception> ExceptionObjLongConsumer<TT, EE> cast(ExceptionObjLongConsumer<T, E> consumer) {
        return consumer;
    }

    public static <T, U, E extends EE, TT extends T, UU extends U, EE extends Exception> ExceptionBiPredicate<TT, UU, EE> cast(ExceptionBiPredicate<T, U, E> predicate) {
        return predicate;
    }

    public static <T, U, R extends RR, E extends EE, TT extends T, UU extends U, RR, EE extends Exception> ExceptionBiFunction<TT, UU, RR, EE> cast(ExceptionBiFunction<T, U, R, E> function) {
        return function;
    }

    public static <T, U, E extends EE, TT extends T, UU extends U, EE extends Exception> ExceptionToIntBiFunction<TT, UU, EE> cast(ExceptionToIntBiFunction<T, U, E> function) {
        return function;
    }

    public static <T, U, E extends EE, TT extends T, UU extends U, EE extends Exception> ExceptionToLongBiFunction<TT, UU, EE> cast(ExceptionToLongBiFunction<T, U, E> function) {
        return function;
    }

    static class RunnableConsumer
    implements Consumer<Runnable> {
        static final Consumer<Runnable> INSTANCE = new RunnableConsumer();

        private RunnableConsumer() {
        }

        @Override
        public void accept(Runnable runnable) {
            runnable.run();
        }
    }

    static class ExceptionRunnableConsumer<E extends Exception>
    implements ExceptionConsumer<ExceptionRunnable<E>, E> {
        static final ExceptionConsumer INSTANCE = new ExceptionRunnableConsumer();

        private ExceptionRunnableConsumer() {
        }

        @Override
        public void accept(ExceptionRunnable<E> ExceptionRunnable2) throws E {
            ExceptionRunnable2.run();
        }
    }

    static class RunnableExceptionConsumer
    implements ExceptionConsumer<Runnable, RuntimeException> {
        static final RunnableExceptionConsumer INSTANCE = new RunnableExceptionConsumer();

        private RunnableExceptionConsumer() {
        }

        @Override
        public void accept(Runnable runnable) throws RuntimeException {
            runnable.run();
        }
    }

    static class ConsumerBiConsumer
    implements BiConsumer<Consumer<Object>, Object> {
        static final BiConsumer INSTANCE = new ConsumerBiConsumer();

        private ConsumerBiConsumer() {
        }

        @Override
        public void accept(Consumer<Object> consumer, Object o) {
            consumer.accept(o);
        }
    }

    static class ExceptionConsumerBiConsumer<E extends Exception>
    implements ExceptionBiConsumer<ExceptionConsumer<Object, E>, Object, E> {
        static final ExceptionBiConsumer INSTANCE = new ExceptionConsumerBiConsumer();

        private ExceptionConsumerBiConsumer() {
        }

        @Override
        public void accept(ExceptionConsumer<Object, E> consumer, Object o) throws E {
            consumer.accept(o);
        }
    }

    static class ConsumerExceptionBiConsumer<T>
    implements ExceptionBiConsumer<Consumer<T>, T, RuntimeException> {
        static final ExceptionBiConsumer INSTANCE = new ConsumerExceptionBiConsumer();

        private ConsumerExceptionBiConsumer() {
        }

        @Override
        public void accept(Consumer<T> consumer, T t) throws RuntimeException {
            consumer.accept(t);
        }
    }

    static class SupplierFunction
    implements Function<Supplier<Object>, Object> {
        static final Function INSTANCE = new SupplierFunction();

        private SupplierFunction() {
        }

        @Override
        public Object apply(Supplier<Object> supplier) {
            return supplier.get();
        }
    }

    static class ExceptionSupplierFunction<E extends Exception>
    implements ExceptionFunction<ExceptionSupplier<Object, E>, Object, E> {
        static final ExceptionFunction INSTANCE = new ExceptionSupplierFunction();

        private ExceptionSupplierFunction() {
        }

        @Override
        public Object apply(ExceptionSupplier<Object, E> supplier) throws E {
            return supplier.get();
        }
    }

    static class SupplierExceptionFunction<R>
    implements ExceptionFunction<Supplier<R>, R, RuntimeException> {
        static final SupplierExceptionFunction INSTANCE = new SupplierExceptionFunction();

        private SupplierExceptionFunction() {
        }

        @Override
        public R apply(Supplier<R> supplier) throws RuntimeException {
            return supplier.get();
        }
    }

    static class FunctionSupplierBiFunction
    implements BiFunction<Function<Supplier<Object>, Object>, Supplier<Object>, Object> {
        static final BiFunction INSTANCE = new FunctionSupplierBiFunction();

        private FunctionSupplierBiFunction() {
        }

        @Override
        public Object apply(Function<Supplier<Object>, Object> function, Supplier<Object> supplier) {
            return function.apply(supplier);
        }
    }

    static class ExceptionFunctionSupplierBiFunction<E extends Exception>
    implements ExceptionBiFunction<ExceptionFunction<ExceptionSupplier<Object, E>, Object, E>, ExceptionSupplier<Object, E>, Object, E> {
        static final ExceptionBiFunction INSTANCE = new ExceptionFunctionSupplierBiFunction();

        private ExceptionFunctionSupplierBiFunction() {
        }

        @Override
        public Object apply(ExceptionFunction<ExceptionSupplier<Object, E>, Object, E> function, ExceptionSupplier<Object, E> supplier) throws E {
            return function.apply(supplier);
        }
    }

    static class FunctionBiFunction<T, R>
    implements BiFunction<Function<T, R>, T, R> {
        static final BiFunction INSTANCE = new FunctionBiFunction();

        private FunctionBiFunction() {
        }

        @Override
        public R apply(Function<T, R> function, T t) {
            return function.apply(t);
        }
    }

    static class ExceptionFunctionBiFunction<T, R, E extends Exception>
    implements ExceptionBiFunction<ExceptionFunction<T, R, E>, T, R, E> {
        static final ExceptionBiFunction INSTANCE = new ExceptionFunctionBiFunction();

        private ExceptionFunctionBiFunction() {
        }

        @Override
        public R apply(ExceptionFunction<T, R, E> function, T t) throws E {
            return function.apply(t);
        }
    }

    static class FunctionExceptionBiFunction<T, R>
    implements ExceptionBiFunction<Function<T, R>, T, R, RuntimeException> {
        static final FunctionExceptionBiFunction INSTANCE = new FunctionExceptionBiFunction();

        private FunctionExceptionBiFunction() {
        }

        @Override
        public R apply(Function<T, R> function, T t) throws RuntimeException {
            return function.apply(t);
        }
    }

    static class ConstantSupplier<T>
    implements Supplier<T>,
    ExceptionSupplier<T, RuntimeException> {
        static final ConstantSupplier NULL = new ConstantSupplier<Object>(null);
        private final T arg1;

        ConstantSupplier(T arg1) {
            this.arg1 = arg1;
        }

        @Override
        public T get() {
            return this.arg1;
        }

        public String toString() {
            return String.format("supplier(%s)", this.arg1);
        }
    }

    static class BiConsumerRunnable<T, U>
    implements Runnable {
        private final BiConsumer<T, U> consumer;
        private final T param1;
        private final U param2;

        BiConsumerRunnable(BiConsumer<T, U> consumer, T param1, U param2) {
            this.consumer = consumer;
            this.param1 = param1;
            this.param2 = param2;
        }

        @Override
        public void run() {
            this.consumer.accept(this.param1, this.param2);
        }

        public String toString() {
            return String.format("%s(%s,%s)", this.consumer, this.param1, this.param2);
        }
    }

    static class ConsumerRunnable<T>
    implements Runnable {
        private final Consumer<T> consumer;
        private final T param;

        ConsumerRunnable(Consumer<T> consumer, T param) {
            this.consumer = consumer;
            this.param = param;
        }

        @Override
        public void run() {
            this.consumer.accept(this.param);
        }

        public String toString() {
            return String.format("%s(%s)", this.consumer, this.param);
        }
    }

    static class ExceptionBiConsumerRunnable<T, U, E extends Exception>
    implements ExceptionRunnable<E> {
        private final ExceptionBiConsumer<T, U, E> consumer;
        private final T param1;
        private final U param2;

        ExceptionBiConsumerRunnable(ExceptionBiConsumer<T, U, E> consumer, T param1, U param2) {
            this.consumer = consumer;
            this.param1 = param1;
            this.param2 = param2;
        }

        @Override
        public void run() throws E {
            this.consumer.accept(this.param1, this.param2);
        }

        public String toString() {
            return String.format("%s(%s,%s)", this.consumer, this.param1, this.param2);
        }
    }

    static class ExceptionConsumerRunnable<T, E extends Exception>
    implements ExceptionRunnable<E> {
        private final ExceptionConsumer<T, E> consumer;
        private final T param;

        ExceptionConsumerRunnable(ExceptionConsumer<T, E> consumer, T param) {
            this.consumer = consumer;
            this.param = param;
        }

        @Override
        public void run() throws E {
            this.consumer.accept(this.param);
        }

        public String toString() {
            return String.format("%s(%s)", this.consumer, this.param);
        }
    }

    static class DiscardingConsumer<T, E extends Exception>
    implements Consumer<T>,
    ExceptionConsumer<T, E> {
        static final DiscardingConsumer INSTANCE = new DiscardingConsumer();

        private DiscardingConsumer() {
        }

        @Override
        public void accept(T t) {
        }
    }

    static class DiscardingBiConsumer<T, U, E extends Exception>
    implements BiConsumer<T, U>,
    ExceptionBiConsumer<T, U, E> {
        static final DiscardingBiConsumer INSTANCE = new DiscardingBiConsumer();

        private DiscardingBiConsumer() {
        }

        @Override
        public void accept(T t, U u) {
        }
    }
}

