/*
 * Decompiled with CFR 0.152.
 */
package libs.org.wildfly.common.iteration;

import java.util.NoSuchElementException;
import libs.org.wildfly.common.iteration.ByteIterator;

final class InterleavedByteArrayIterator
extends ByteIterator {
    private final int len;
    private final byte[] bytes;
    private final int offs;
    private final int[] interleave;
    private int idx;

    InterleavedByteArrayIterator(int len, byte[] bytes, int offs, int[] interleave) {
        this.len = len;
        this.bytes = bytes;
        this.offs = offs;
        this.interleave = interleave;
        this.idx = 0;
    }

    @Override
    public boolean hasNext() {
        return this.idx < this.len;
    }

    @Override
    public boolean hasPrevious() {
        return this.idx > 0;
    }

    @Override
    public int next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.bytes[this.offs + this.interleave[this.idx++]] & 0xFF;
    }

    @Override
    public int previous() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        return this.bytes[this.offs + this.interleave[--this.idx]] & 0xFF;
    }

    @Override
    public int peekNext() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.bytes[this.offs + this.interleave[this.idx]] & 0xFF;
    }

    @Override
    public int peekPrevious() throws NoSuchElementException {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        return this.bytes[this.offs + this.interleave[this.idx - 1]] & 0xFF;
    }

    @Override
    public long getIndex() {
        return this.idx;
    }
}

