/*
 * Decompiled with CFR 0.152.
 */
package libs.org.xnio;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collections;
import libs.org.wildfly.client.config.ClientConfiguration;
import libs.org.wildfly.client.config.ConfigXMLParseException;
import libs.org.wildfly.client.config.ConfigurationXMLStreamReader;
import libs.org.wildfly.common.net.CidrAddress;
import libs.org.xnio.Xnio;
import libs.org.xnio.XnioWorker;

final class XnioXmlParser {
    private static final String NS_XNIO_3_5 = "urn:xnio:3.5";

    XnioXmlParser() {
    }

    static XnioWorker parseWorker(Xnio xnio) throws ConfigXMLParseException, IOException {
        return XnioXmlParser.parseWorker(xnio, ClientConfiguration.getInstance());
    }

    static XnioWorker parseWorker(Xnio xnio, ClientConfiguration clientConfiguration) throws ConfigXMLParseException, IOException {
        XnioWorker.Builder builder = xnio.createWorkerBuilder();
        if (clientConfiguration == null) {
            return null;
        }
        builder.setDaemon(true);
        ConfigurationXMLStreamReader reader = clientConfiguration.readConfiguration(Collections.singleton(NS_XNIO_3_5));
        XnioXmlParser.parseDocument(reader, builder);
        return builder.build();
    }

    private static void parseDocument(ConfigurationXMLStreamReader reader, XnioWorker.Builder workerBuilder) throws ConfigXMLParseException {
        if (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 1: {
                    XnioXmlParser.checkElementNamespace(reader);
                    switch (reader.getLocalName()) {
                        case "worker": {
                            XnioXmlParser.parseWorkerElement(reader, workerBuilder);
                            break block0;
                        }
                    }
                    throw reader.unexpectedElement();
                }
                default: {
                    throw reader.unexpectedContent();
                }
            }
        }
    }

    private static void parseWorkerElement(ConfigurationXMLStreamReader reader, XnioWorker.Builder workerBuilder) throws ConfigXMLParseException {
        XnioXmlParser.requireNoAttributes(reader);
        int foundBits = 0;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    XnioXmlParser.checkElementNamespace(reader);
                    switch (reader.getLocalName()) {
                        case "daemon-threads": {
                            if (XnioXmlParser.isSet(foundBits, 0)) {
                                throw reader.unexpectedElement();
                            }
                            foundBits = XnioXmlParser.setBit(foundBits, 0);
                            XnioXmlParser.parseDaemonThreads(reader, workerBuilder);
                            break block0;
                        }
                        case "worker-name": {
                            if (XnioXmlParser.isSet(foundBits, 1)) {
                                throw reader.unexpectedElement();
                            }
                            foundBits = XnioXmlParser.setBit(foundBits, 1);
                            XnioXmlParser.parseWorkerName(reader, workerBuilder);
                            break block0;
                        }
                        case "pool-size": {
                            if (XnioXmlParser.isSet(foundBits, 2)) {
                                throw reader.unexpectedElement();
                            }
                            foundBits = XnioXmlParser.setBit(foundBits, 2);
                            XnioXmlParser.parsePoolSize(reader, workerBuilder);
                            break block0;
                        }
                        case "task-keepalive": {
                            if (XnioXmlParser.isSet(foundBits, 3)) {
                                throw reader.unexpectedElement();
                            }
                            foundBits = XnioXmlParser.setBit(foundBits, 3);
                            XnioXmlParser.parseTaskKeepalive(reader, workerBuilder);
                            break block0;
                        }
                        case "io-threads": {
                            if (XnioXmlParser.isSet(foundBits, 4)) {
                                throw reader.unexpectedElement();
                            }
                            foundBits = XnioXmlParser.setBit(foundBits, 4);
                            XnioXmlParser.parseIoThreads(reader, workerBuilder);
                            break block0;
                        }
                        case "stack-size": {
                            if (XnioXmlParser.isSet(foundBits, 5)) {
                                throw reader.unexpectedElement();
                            }
                            foundBits = XnioXmlParser.setBit(foundBits, 5);
                            XnioXmlParser.parseStackSize(reader, workerBuilder);
                            break block0;
                        }
                        case "outbound-bind-addresses": {
                            if (XnioXmlParser.isSet(foundBits, 6)) {
                                throw reader.unexpectedElement();
                            }
                            foundBits = XnioXmlParser.setBit(foundBits, 6);
                            XnioXmlParser.parseOutboundBindAddresses(reader, workerBuilder);
                            break block0;
                        }
                    }
                    throw reader.unexpectedElement();
                }
            }
        }
        throw reader.unexpectedDocumentEnd();
    }

    private static void parseDaemonThreads(ConfigurationXMLStreamReader reader, XnioWorker.Builder workerBuilder) throws ConfigXMLParseException {
        XnioXmlParser.requireSingleAttribute(reader, "value");
        boolean daemon = reader.getBooleanAttributeValueResolved(0);
        if (!reader.hasNext()) {
            throw reader.unexpectedDocumentEnd();
        }
        if (reader.nextTag() != 2) {
            throw reader.unexpectedElement();
        }
        workerBuilder.setDaemon(daemon);
    }

    private static void parseWorkerName(ConfigurationXMLStreamReader reader, XnioWorker.Builder workerBuilder) throws ConfigXMLParseException {
        XnioXmlParser.requireSingleAttribute(reader, "value");
        String name = reader.getAttributeValueResolved(0);
        if (!reader.hasNext()) {
            throw reader.unexpectedDocumentEnd();
        }
        if (reader.nextTag() != 2) {
            throw reader.unexpectedElement();
        }
        workerBuilder.setWorkerName(name);
    }

    private static void parsePoolSize(ConfigurationXMLStreamReader reader, XnioWorker.Builder workerBuilder) throws ConfigXMLParseException {
        XnioXmlParser.requireSingleAttribute(reader, "max-threads");
        int threadCount = reader.getIntAttributeValueResolved(0);
        if (!reader.hasNext()) {
            throw reader.unexpectedDocumentEnd();
        }
        if (reader.nextTag() != 2) {
            throw reader.unexpectedElement();
        }
        workerBuilder.setCoreWorkerPoolSize(threadCount);
        workerBuilder.setMaxWorkerPoolSize(threadCount);
    }

    private static void parseTaskKeepalive(ConfigurationXMLStreamReader reader, XnioWorker.Builder workerBuilder) throws ConfigXMLParseException {
        XnioXmlParser.requireSingleAttribute(reader, "value");
        int duration = reader.getIntAttributeValueResolved(0);
        if (!reader.hasNext()) {
            throw reader.unexpectedDocumentEnd();
        }
        if (reader.nextTag() != 2) {
            throw reader.unexpectedElement();
        }
        workerBuilder.setWorkerKeepAlive(duration);
    }

    private static void parseIoThreads(ConfigurationXMLStreamReader reader, XnioWorker.Builder workerBuilder) throws ConfigXMLParseException {
        XnioXmlParser.requireSingleAttribute(reader, "value");
        int threadCount = reader.getIntAttributeValueResolved(0);
        if (!reader.hasNext()) {
            throw reader.unexpectedDocumentEnd();
        }
        if (reader.nextTag() != 2) {
            throw reader.unexpectedElement();
        }
        workerBuilder.setWorkerIoThreads(threadCount);
    }

    private static void parseStackSize(ConfigurationXMLStreamReader reader, XnioWorker.Builder workerBuilder) throws ConfigXMLParseException {
        XnioXmlParser.requireSingleAttribute(reader, "value");
        long stackSize = reader.getLongAttributeValueResolved(0);
        if (!reader.hasNext()) {
            throw reader.unexpectedDocumentEnd();
        }
        if (reader.nextTag() != 2) {
            throw reader.unexpectedElement();
        }
        workerBuilder.setWorkerStackSize(stackSize);
    }

    private static void parseOutboundBindAddresses(ConfigurationXMLStreamReader reader, XnioWorker.Builder workerBuilder) throws ConfigXMLParseException {
        XnioXmlParser.requireNoAttributes(reader);
        while (true) {
            if (!reader.hasNext()) {
                throw reader.unexpectedDocumentEnd();
            }
            if (reader.nextTag() != 1) break;
            XnioXmlParser.checkElementNamespace(reader);
            if (!reader.getLocalName().equals("bind-address")) {
                throw reader.unexpectedElement();
            }
            XnioXmlParser.parseBindAddress(reader, workerBuilder);
        }
        assert (reader.getEventType() == 2);
    }

    private static void parseBindAddress(ConfigurationXMLStreamReader reader, XnioWorker.Builder workerBuilder) throws ConfigXMLParseException {
        int cnt = reader.getAttributeCount();
        InetAddress address = null;
        int port = 0;
        CidrAddress match = null;
        block10: for (int i = 0; i < cnt; ++i) {
            XnioXmlParser.checkAttributeNamespace(reader, i);
            switch (reader.getAttributeLocalName(i)) {
                case "match": {
                    match = reader.getCidrAddressAttributeValueResolved(i);
                    continue block10;
                }
                case "bind-address": {
                    address = reader.getInetAddressAttributeValueResolved(i);
                    continue block10;
                }
                case "bind-port": {
                    port = reader.getIntAttributeValueResolved(i, 0, 65535);
                    continue block10;
                }
                default: {
                    throw reader.unexpectedAttribute(i);
                }
            }
        }
        if (match == null) {
            throw reader.missingRequiredAttribute(null, "match");
        }
        if (address == null) {
            throw reader.missingRequiredAttribute(null, "bind-address");
        }
        workerBuilder.addBindAddressConfiguration(match, new InetSocketAddress(address, port));
        if (!reader.hasNext()) {
            throw reader.unexpectedDocumentEnd();
        }
        if (reader.nextTag() != 2) {
            throw reader.unexpectedElement();
        }
    }

    private static void checkElementNamespace(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        if (!reader.getNamespaceURI().equals(NS_XNIO_3_5)) {
            throw reader.unexpectedElement();
        }
    }

    private static void checkAttributeNamespace(ConfigurationXMLStreamReader reader, int idx) throws ConfigXMLParseException {
        String attributeNamespace = reader.getAttributeNamespace(idx);
        if (attributeNamespace != null && !attributeNamespace.isEmpty()) {
            throw reader.unexpectedAttribute(idx);
        }
    }

    private static void requireNoAttributes(ConfigurationXMLStreamReader reader) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        if (attributeCount > 0) {
            throw reader.unexpectedAttribute(0);
        }
    }

    private static void requireSingleAttribute(ConfigurationXMLStreamReader reader, String attributeName) throws ConfigXMLParseException {
        int attributeCount = reader.getAttributeCount();
        if (attributeCount < 1) {
            throw reader.missingRequiredAttribute("", attributeName);
        }
        XnioXmlParser.checkAttributeNamespace(reader, 0);
        if (!reader.getAttributeLocalName(0).equals(attributeName)) {
            throw reader.unexpectedAttribute(0);
        }
        if (attributeCount > 1) {
            throw reader.unexpectedAttribute(1);
        }
    }

    private static boolean isSet(int var, int bit) {
        return (var & 1 << bit) != 0;
    }

    private static int setBit(int var, int bit) {
        return var | 1 << bit;
    }
}

