/*
 * Decompiled with CFR 0.152.
 */
package libs.org.xnio.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import libs.org.xnio._private.Messages;
import libs.org.xnio.channels.StreamSourceChannel;
import libs.org.xnio.conduits.AbstractStreamSinkConduit;
import libs.org.xnio.conduits.ConduitWritableByteChannel;
import libs.org.xnio.conduits.Conduits;
import libs.org.xnio.conduits.StreamSinkConduit;
import libs.org.xnio.ssl.JsseSslConduitEngine;

final class JsseSslStreamSinkConduit
extends AbstractStreamSinkConduit<StreamSinkConduit> {
    private final JsseSslConduitEngine sslEngine;
    private volatile boolean tls;

    protected JsseSslStreamSinkConduit(StreamSinkConduit next, JsseSslConduitEngine sslEngine, boolean tls) {
        super(next);
        if (sslEngine == null) {
            throw Messages.msg.nullParameter("sslEngine");
        }
        this.sslEngine = sslEngine;
        this.tls = tls;
    }

    public void enableTls() {
        this.tls = true;
        if (this.isWriteResumed()) {
            this.wakeupWrites();
        }
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        return src.transferTo(position, count, new ConduitWritableByteChannel(this));
    }

    @Override
    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        return Conduits.transfer(source, count, throughBuffer, this);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.write(src, false);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offs, int len) throws IOException {
        return this.write(srcs, offs, len, false);
    }

    @Override
    public int writeFinal(ByteBuffer src) throws IOException {
        return this.write(src, true);
    }

    @Override
    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this.write(srcs, offset, length, true);
    }

    private int write(ByteBuffer src, boolean writeFinal) throws IOException {
        if (!this.tls) {
            if (writeFinal) {
                return ((StreamSinkConduit)this.next).writeFinal(src);
            }
            return ((StreamSinkConduit)this.next).write(src);
        }
        int wrappedBytes = this.sslEngine.wrap(src);
        if (wrappedBytes > 0) {
            this.writeWrappedBuffer(writeFinal);
        }
        return wrappedBytes;
    }

    private long write(ByteBuffer[] srcs, int offs, int len, boolean writeFinal) throws IOException {
        if (!this.tls) {
            if (writeFinal) {
                return super.writeFinal(srcs, offs, len);
            }
            return super.write(srcs, offs, len);
        }
        long wrappedBytes = this.sslEngine.wrap(srcs, offs, len);
        if (wrappedBytes > 0L) {
            this.writeWrappedBuffer(writeFinal);
        }
        return wrappedBytes;
    }

    @Override
    public void resumeWrites() {
        if (this.tls && this.sslEngine.isFirstHandshake()) {
            super.wakeupWrites();
        } else {
            super.resumeWrites();
        }
    }

    @Override
    public void terminateWrites() throws IOException {
        if (!this.tls) {
            super.terminateWrites();
            return;
        }
        try {
            this.sslEngine.closeOutbound();
            this.flush();
        }
        catch (IOException e) {
            try {
                super.truncateWrites();
            }
            catch (IOException e2) {
                e2.addSuppressed(e);
                throw e2;
            }
            throw e;
        }
    }

    @Override
    public void awaitWritable() throws IOException {
        if (this.tls) {
            this.sslEngine.awaitCanWrap();
        }
        super.awaitWritable();
    }

    @Override
    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        if (!this.tls) {
            super.awaitWritable(time, timeUnit);
            return;
        }
        long duration = timeUnit.toNanos(time);
        long awaited = System.nanoTime();
        this.sslEngine.awaitCanWrap(time, timeUnit);
        awaited = System.nanoTime() - awaited;
        if (awaited > duration) {
            return;
        }
        super.awaitWritable(duration - awaited, TimeUnit.NANOSECONDS);
    }

    @Override
    public void truncateWrites() throws IOException {
        if (this.tls) {
            try {
                this.sslEngine.closeOutbound();
            }
            finally {
                try {
                    super.truncateWrites();
                }
                catch (IOException iOException) {}
            }
        }
        super.truncateWrites();
    }

    @Override
    public boolean flush() throws IOException {
        if (!this.tls) {
            return super.flush();
        }
        if (this.sslEngine.isOutboundClosed()) {
            if (this.sslEngine.flush() && this.writeWrappedBuffer(false) && super.flush()) {
                super.terminateWrites();
                return true;
            }
            return false;
        }
        return this.sslEngine.flush() && this.writeWrappedBuffer(false) && super.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean writeWrappedBuffer(boolean writeFinal) throws IOException {
        var2_2 = this.sslEngine.getWrapLock();
        synchronized (var2_2) {
            wrapBuffer = this.sslEngine.getWrappedBuffer();
            while (true) {
                try {
                    do lbl-1000:
                    // 3 sources

                    {
                        if (!wrapBuffer.flip().hasRemaining()) {
                            if (writeFinal) {
                                this.terminateWrites();
                            }
                            var4_4 = true;
                            return var4_4;
                        }
                        if (!writeFinal) continue;
                        if (super.writeFinal(wrapBuffer) != 0) ** GOTO lbl-1000
                        var4_5 = false;
                        return var4_5;
                    } while (super.write(wrapBuffer) != 0);
                    var4_6 = false;
                    return var4_6;
                }
                finally {
                    wrapBuffer.compact();
                    continue;
                }
                break;
            }
        }
    }
}

