/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.bukkit;

import com.google.common.io.ByteArrayDataOutput;
import io.netty.buffer.Unpooled;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.pl3x.map.bukkit.Pl3xMapBukkit;
import net.pl3x.map.bukkit.network.ClientboundMapPayload;
import net.pl3x.map.bukkit.network.ClientboundServerPayload;
import net.pl3x.map.bukkit.network.ServerboundMapPayload;
import net.pl3x.map.bukkit.network.ServerboundServerPayload;
import net.pl3x.map.core.configuration.Config;
import net.pl3x.map.core.network.Network;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class BukkitNetwork
extends Network {
    private final Pl3xMapBukkit plugin;

    public BukkitNetwork(Pl3xMapBukkit plugin) {
        this.plugin = plugin;
    }

    @Override
    public void register() {
        Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)this.plugin, ClientboundServerPayload.TYPE.a().toString());
        Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)this.plugin, ClientboundMapPayload.TYPE.a().toString());
        Bukkit.getMessenger().registerIncomingPluginChannel((Plugin)this.plugin, ServerboundServerPayload.TYPE.a().toString(), (channel, player, bytes) -> {
            ClientboundServerPayload payload = new ClientboundServerPayload(3, 200, Config.WEB_ADDRESS);
            PacketDataSerializer friendlyByteBuf = new PacketDataSerializer(Unpooled.buffer());
            ClientboundServerPayload.STREAM_CODEC.encode((Object)friendlyByteBuf, (Object)payload);
            this.sendCustomPayloadPacket(player, payload, friendlyByteBuf);
        });
        Bukkit.getMessenger().registerIncomingPluginChannel((Plugin)this.plugin, ServerboundMapPayload.TYPE.a().toString(), (channel, player, bytes) -> {
            PacketDataSerializer byteBuf = new PacketDataSerializer(Unpooled.copiedBuffer((byte[])bytes));
            ServerboundMapPayload payload = (ServerboundMapPayload)ServerboundMapPayload.STREAM_CODEC.decode((Object)byteBuf);
            MapView map = Bukkit.getMap((int)payload.mapId());
            if (map == null) {
                ClientboundMapPayload customPacketPayload = new ClientboundMapPayload(3, -1, payload.mapId());
                PacketDataSerializer friendlyByteBuf = new PacketDataSerializer(Unpooled.buffer((int)bytes.length));
                ClientboundMapPayload.STREAM_CODEC.encode((Object)friendlyByteBuf, (Object)customPacketPayload);
                this.sendCustomPayloadPacket(player, customPacketPayload, friendlyByteBuf);
                return;
            }
            World world = map.getWorld();
            if (world == null) {
                ClientboundMapPayload customPacketPayload = new ClientboundMapPayload(3, -2, payload.mapId());
                PacketDataSerializer friendlyByteBuf = new PacketDataSerializer(Unpooled.buffer());
                ClientboundMapPayload.STREAM_CODEC.encode((Object)friendlyByteBuf, (Object)customPacketPayload);
                this.sendCustomPayloadPacket(player, customPacketPayload, friendlyByteBuf);
                return;
            }
            ClientboundMapPayload customPacketPayload = new ClientboundMapPayload(3, 200, payload.mapId(), this.getScale(map), map.getCenterX(), map.getCenterZ(), world.getName());
            PacketDataSerializer friendlyByteBuf = new PacketDataSerializer(Unpooled.buffer());
            ClientboundMapPayload.STREAM_CODEC.encode((Object)friendlyByteBuf, (Object)customPacketPayload);
            this.sendCustomPayloadPacket(player, customPacketPayload, friendlyByteBuf);
        });
    }

    private void sendCustomPayloadPacket(Player player, CustomPacketPayload customPacketPayload, PacketDataSerializer friendlyByteBuf) {
        byte[] byteArray = new byte[friendlyByteBuf.readableBytes()];
        friendlyByteBuf.b(byteArray);
        player.sendPluginMessage((Plugin)this.plugin, customPacketPayload.a().a().toString(), byteArray);
    }

    @Override
    public void unregister() {
        Bukkit.getMessenger().unregisterOutgoingPluginChannel((Plugin)this.plugin, ClientboundServerPayload.TYPE.a().toString());
        Bukkit.getMessenger().unregisterOutgoingPluginChannel((Plugin)this.plugin, ClientboundMapPayload.TYPE.a().toString());
        Bukkit.getMessenger().unregisterIncomingPluginChannel((Plugin)this.plugin, ServerboundServerPayload.TYPE.a().toString());
        Bukkit.getMessenger().unregisterIncomingPluginChannel((Plugin)this.plugin, ServerboundMapPayload.TYPE.a().toString());
    }

    @Override
    protected <T> void sendServerData(T player) {
    }

    @Override
    protected <T> void sendMapData(T player, int id) {
    }

    @Override
    protected <T> void send(T player, ByteArrayDataOutput out) {
    }

    private byte getScale(MapView map) {
        return map.getScale().getValue();
    }
}

