/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.bukkit;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.properties.Property;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.UUID;
import net.minecraft.server.level.EntityPlayer;
import net.pl3x.map.bukkit.BukkitWorld;
import net.pl3x.map.bukkit.Pl3xMapBukkit;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.markers.Point;
import net.pl3x.map.core.world.World;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class BukkitPlayer
extends net.pl3x.map.core.player.Player {
    private final NamespacedKey hiddenKey = new NamespacedKey((Plugin)Pl3xMapBukkit.getProvidingPlugin(Pl3xMapBukkit.class), "hidden");

    public BukkitPlayer(Player player) {
        super(player.getName(), player);
    }

    public Player getPlayer() {
        return (Player)super.getPlayer();
    }

    @Override
    public String getName() {
        return this.getPlayer().getName();
    }

    @Override
    public UUID getUUID() {
        return this.getPlayer().getUniqueId();
    }

    @Override
    public World getWorld() {
        org.bukkit.World world = this.getPlayer().getWorld();
        return Pl3xMap.api().getWorldRegistry().getOrDefault(world.getName(), () -> new BukkitWorld(((CraftWorld)world).getHandle(), world.getName()));
    }

    @Override
    public Point getPosition() {
        Location loc = this.getPlayer().getLocation();
        return Point.of(loc.getBlockX(), loc.getBlockZ());
    }

    @Override
    public float getYaw() {
        return this.getPlayer().getLocation().getYaw();
    }

    @Override
    public int getHealth() {
        return (int)Math.round(this.getPlayer().getHealth());
    }

    @Override
    public int getArmorPoints() {
        AttributeInstance attr = this.getPlayer().getAttribute(Attribute.ARMOR);
        return attr == null ? 0 : (int)Math.round(attr.getValue());
    }

    @Override
    public @Nullable URL getSkin() {
        try {
            EntityPlayer player = ((CraftPlayer)this.getPlayer()).getHandle();
            Property property = player.gz().properties().get((Object)"textures").stream().findFirst().orElse(null);
            if (property == null) {
                return null;
            }
            String json = new String(Base64.getDecoder().decode(property.value()), StandardCharsets.UTF_8);
            JsonElement jsonElement = JsonParser.parseString((String)json);
            if (!jsonElement.isJsonObject()) {
                return null;
            }
            JsonObject jsonObject = jsonElement.getAsJsonObject().getAsJsonObject("textures");
            if (jsonObject == null) {
                return null;
            }
            JsonObject skin = jsonObject.get("SKIN").getAsJsonObject();
            if (skin == null) {
                return null;
            }
            String url = skin.get("url").getAsString();
            if (url == null) {
                return null;
            }
            return new URI(url).toURL();
        }
        catch (Throwable e) {
            return null;
        }
    }

    @Override
    public boolean isInvisible() {
        return this.getPlayer().isInvisible();
    }

    @Override
    public boolean isNPC() {
        return this.getPlayer().hasMetadata("NPC");
    }

    @Override
    public boolean isSpectator() {
        return this.getPlayer().getGameMode() == GameMode.SPECTATOR;
    }

    @Override
    public boolean isPersistentlyHidden() {
        return (Byte)this.getPlayer().getPersistentDataContainer().getOrDefault(this.hiddenKey, PersistentDataType.BYTE, (Object)0) != 0;
    }

    @Override
    public void setPersistentlyHidden(boolean hidden) {
        this.getPlayer().getPersistentDataContainer().set(this.hiddenKey, PersistentDataType.BYTE, (Object)((byte)(hidden ? 1 : 0)));
    }

    @Override
    public String toString() {
        return "BukkitPlayer{player=" + String.valueOf(this.getPlayer().getUniqueId()) + "}";
    }
}

