/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.command.commands;

import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.pl3x.map.core.command.CommandHandler;
import net.pl3x.map.core.command.Pl3xMapCommand;
import net.pl3x.map.core.command.Sender;
import net.pl3x.map.core.configuration.Lang;
import net.pl3x.map.core.player.Player;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.description.Description;
import org.incendo.cloud.minecraft.extras.RichDescription;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class HideCommand
extends Pl3xMapCommand {
    public HideCommand(CommandHandler handler) {
        super(handler);
    }

    @Override
    public void register() {
        this.getHandler().registerSubcommand(builder -> builder.literal("hide", new String[0]).commandDescription(RichDescription.of(Lang.parse(Lang.COMMAND_HIDE_DESCRIPTION, new TagResolver.Single[0]))).permission("pl3xmap.command.hide").handler(this::execute));
        this.getHandler().registerSubcommand(builder -> builder.literal("hide", new String[0]).optional("player", this.getHandler().getPlatformParsers().playerSelectorParser(), (Description)HideCommand.description(Lang.COMMAND_ARGUMENT_OPTIONAL_PLAYER_DESCRIPTION, new TagResolver.Single[0])).commandDescription(RichDescription.of(Lang.parse(Lang.COMMAND_HIDE_DESCRIPTION, new TagResolver.Single[0]))).permission("pl3xmap.command.hide.others").handler(this::execute));
    }

    private void execute(CommandContext<Sender> context) {
        Sender sender = context.sender();
        Player player = this.getHandler().getPlatformParsers().resolvePlayerFromPlayerSelector("player", context);
        if (player == null) {
            sender.sendMessage(Lang.ERROR_MUST_SPECIFY_PLAYER);
            return;
        }
        if (player.isHidden()) {
            sender.sendMessage(Lang.COMMAND_HIDE_ALREADY_HIDDEN, Placeholder.unparsed("player", player.getName()));
            return;
        }
        player.setHidden(true, true);
        sender.sendMessage(Lang.COMMAND_HIDE_SUCCESS, Placeholder.unparsed("player", player.getName()));
    }
}

