/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.image;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.pl3x.map.core.Keyed;
import net.pl3x.map.core.configuration.Config;
import net.pl3x.map.core.image.io.IO;
import net.pl3x.map.core.log.Logger;
import net.pl3x.map.core.markers.Point;
import net.pl3x.map.core.util.Colors;
import net.pl3x.map.core.util.FileUtil;
import net.pl3x.map.core.world.World;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class TileImage
extends Keyed {
    private static final Map<Path, ReadWriteLock> FILE_LOCKS = new ConcurrentHashMap<Path, ReadWriteLock>();
    public static final String DIR_PATH = "%d/%s/";
    public static final String FILE_PATH = "%d_%d.%s";
    private final World world;
    private final Point region;
    private final int[] pixels = new int[262144];
    private final IO.Type io;
    private boolean written = false;

    public TileImage(String key, World world, Point region) {
        super(key);
        this.world = world;
        this.region = region;
        this.io = IO.get(Config.WEB_TILE_FORMAT);
    }

    public int getIndex(int x, int z) {
        return ((z & 0x1FF) << 9) + (x & 0x1FF);
    }

    public int getPixel(int x, int z) {
        return this.pixels[this.getIndex(x, z)];
    }

    public void setPixel(int x, int z, int color) {
        this.pixels[this.getIndex((int)x, (int)z)] = color;
        this.written = true;
    }

    public void saveToDisk() {
        if (!this.written) {
            return;
        }
        for (int zoom = 0; zoom <= this.world.getConfig().ZOOM_MAX_OUT; ++zoom) {
            Path dirPath = this.world.getTilesDirectory().resolve(String.format(DIR_PATH, zoom, this.getKey()));
            FileUtil.createDirs(dirPath);
            Path filePath = dirPath.resolve(String.format(FILE_PATH, this.region.x() >> zoom, this.region.z() >> zoom, this.io.getKey()));
            ReadWriteLock lock = FILE_LOCKS.computeIfAbsent(filePath, k -> new ReentrantReadWriteLock(true));
            lock.writeLock().lock();
            try {
                BufferedImage buffer = this.getBuffer(filePath);
                this.writePixels(buffer, 512 >> zoom, zoom);
                this.io.write(filePath, buffer);
            }
            catch (Throwable t) {
                Logger.severe("Failed to read/write tile at path %s".formatted(filePath), t);
            }
            lock.writeLock().unlock();
        }
    }

    private BufferedImage getBuffer(Path path) throws IOException {
        BufferedImage buffer = null;
        if (Files.exists(path, new LinkOption[0]) && Files.size(path) > 0L) {
            buffer = this.io.read(path);
        }
        if (buffer == null) {
            buffer = this.io.createBuffer();
        }
        return buffer;
    }

    private void writePixels(BufferedImage buffer, int size, int zoom) {
        int step = 1 << zoom;
        int baseX = this.region.x() * size & 0x1FF;
        int baseZ = this.region.z() * size & 0x1FF;
        for (int x = 0; x < 512; x += step) {
            for (int z = 0; z < 512; z += step) {
                int argb = this.getPixel(x, z);
                if (argb == 0) continue;
                if (step > 1) {
                    argb = this.downSample(x, z, argb, step);
                }
                buffer.setRGB(baseX + (x >> zoom), baseZ + (z >> zoom), this.io.color(argb));
            }
        }
    }

    private int downSample(int x, int z, int rgb, int step) {
        int a2 = 0;
        int r = 0;
        int g = 0;
        int b2 = 0;
        int c = 0;
        for (int i = 0; i < step; ++i) {
            for (int j = 0; j < step; ++j) {
                if (i != 0 && j != 0) {
                    rgb = this.getPixel(x + i, z + j);
                }
                a2 += Colors.alpha(rgb);
                r += Colors.red(rgb);
                g += Colors.green(rgb);
                b2 += Colors.blue(rgb);
                ++c;
            }
        }
        return Colors.argb(a2 / c, r / c, g / c, b2 / c);
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        TileImage other = (TileImage)o;
        return this.getKey().equals(other.getKey()) && this.region.equals(other.region) && this.world.equals(other.world);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getKey(), this.region, this.world);
    }

    @Override
    public String toString() {
        return "TileImage{key=" + this.getKey() + ",region=" + String.valueOf(this.region) + ",world=" + String.valueOf(this.world) + "}";
    }
}

