/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.markers.area;

import java.util.LinkedHashMap;
import java.util.Map;
import net.pl3x.map.core.markers.area.Area;
import net.pl3x.map.core.world.World;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class Border
implements Area {
    private final World world;

    public Border(World world) {
        this.world = world;
    }

    public int getMinX() {
        return (int)this.world.getBorderMinX();
    }

    public int getMinZ() {
        return (int)this.world.getBorderMinZ();
    }

    public int getMaxX() {
        return (int)this.world.getBorderMaxX();
    }

    public int getMaxZ() {
        return (int)this.world.getBorderMaxZ();
    }

    @Override
    public boolean containsBlock(int blockX, int blockZ) {
        return blockX >= this.getMinX() && blockX <= this.getMaxX() && blockZ >= this.getMinZ() && blockZ <= this.getMaxZ();
    }

    @Override
    public boolean containsChunk(int chunkX, int chunkZ) {
        return chunkX >= this.getMinX() >> 4 && chunkX <= this.getMaxX() >> 4 && chunkZ >= this.getMinZ() >> 4 && chunkZ <= this.getMaxZ() >> 4;
    }

    @Override
    public boolean containsRegion(int regionX, int regionZ) {
        return regionX >= this.getMinX() >> 9 && regionX <= this.getMaxX() >> 9 && regionZ >= this.getMinZ() >> 9 && regionZ <= this.getMaxZ() >> 9;
    }

    @Override
    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("type", "world-border");
        return map;
    }

    public static Border deserialize(World world, Map<String, Object> map) {
        return new Border(world);
    }

    public String toString() {
        return "Border{minX=" + this.getMinX() + ",minZ=" + this.getMinZ() + ",maxX=" + this.getMaxX() + ",maxZ=" + this.getMaxZ() + "}";
    }
}

