/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.markers.area;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.pl3x.map.core.markers.area.Area;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class Rectangle
implements Area {
    private final int minX;
    private final int minZ;
    private final int maxX;
    private final int maxZ;

    public Rectangle(int minx, int z1, int x2, int z2) {
        this.minX = Math.min(minx, x2);
        this.minZ = Math.min(z1, z2);
        this.maxX = Math.max(minx, x2);
        this.maxZ = Math.max(z1, z2);
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMinZ() {
        return this.minZ;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMaxZ() {
        return this.maxZ;
    }

    @Override
    public boolean containsBlock(int blockX, int blockZ) {
        return blockX >= this.getMinX() && blockX <= this.getMaxX() && blockZ >= this.getMinZ() && blockZ <= this.getMaxZ();
    }

    @Override
    public boolean containsChunk(int chunkX, int chunkZ) {
        return chunkX >= this.getMinX() >> 4 && chunkX <= this.getMaxX() >> 4 && chunkZ >= this.getMinZ() >> 4 && chunkZ <= this.getMaxZ() >> 4;
    }

    @Override
    public boolean containsRegion(int regionX, int regionZ) {
        return regionX >= this.getMinX() >> 9 && regionX <= this.getMaxX() >> 9 && regionZ >= this.getMinZ() >> 9 && regionZ <= this.getMaxZ() >> 9;
    }

    @Override
    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("type", "rectangle");
        map.put("min-x", this.getMinX());
        map.put("min-z", this.getMinZ());
        map.put("max-x", this.getMaxX());
        map.put("max-z", this.getMaxZ());
        return map;
    }

    public static Rectangle deserialize(Map<String, Object> map) {
        return new Rectangle((Integer)map.get("min-x"), (Integer)map.get("min-z"), (Integer)map.get("max-x"), (Integer)map.get("max-z"));
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Rectangle other = (Rectangle)o;
        return this.getMinX() == other.getMinX() && this.getMinZ() == other.getMinZ() && this.getMaxX() == other.getMaxX() && this.getMaxZ() == other.getMaxZ();
    }

    public int hashCode() {
        return Objects.hash(this.getMinX(), this.getMinZ(), this.getMaxX(), this.getMaxZ());
    }

    public String toString() {
        return "Rectangle{minX=" + this.getMinX() + ",minZ=" + this.getMinZ() + ",maxX=" + this.getMaxX() + ",maxZ=" + this.getMaxZ() + "}";
    }
}

