/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.markers.marker;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.pl3x.map.core.markers.JsonObjectWrapper;
import net.pl3x.map.core.markers.Point;
import net.pl3x.map.core.markers.marker.Marker;
import net.pl3x.map.core.util.Preconditions;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class Polyline
extends Marker<Polyline> {
    private final List<Point> points = new ArrayList<Point>();

    private Polyline(String key) {
        super("line", key);
    }

    public Polyline(String key, Point point) {
        this(key);
        this.addPoint(point);
    }

    public Polyline(String key, Point ... points) {
        this(key);
        this.addPoint(points);
    }

    public Polyline(String key, Collection<Point> points) {
        this(key);
        this.addPoint(points);
    }

    public static Polyline of(String key, Point point) {
        return new Polyline(key, point);
    }

    public static Polyline of(String key, Point ... points) {
        return new Polyline(key, points);
    }

    public static Polyline of(String key, Collection<Point> points) {
        return new Polyline(key, points);
    }

    public List<Point> getPoints() {
        return this.points;
    }

    public Polyline clearPoints() {
        this.points.clear();
        return this;
    }

    public Polyline loop() {
        Preconditions.checkState(!this.points.isEmpty(), "No points to loop back on");
        Point first = this.points.getFirst();
        Point last = this.points.getLast();
        Preconditions.checkState(!first.equals(last), "First and last points are the same");
        this.points.add(first);
        return this;
    }

    public Polyline addPoint(Point point) {
        Preconditions.checkNotNull(point, "Polyline point is null");
        this.points.add(point);
        return this;
    }

    public Polyline addPoint(Point ... points) {
        Preconditions.checkNotNull(points, "Polyline points is null");
        for (Point point : points) {
            this.addPoint(point);
        }
        return this;
    }

    public Polyline addPoint(Collection<Point> points) {
        Preconditions.checkNotNull(points, "Polyline points is null");
        this.points.addAll(points);
        return this;
    }

    public Polyline removePoint(Point point) {
        Preconditions.checkNotNull(point, "Polyline point is null");
        this.points.remove(point);
        return this;
    }

    public Polyline removePoint(Point ... points) {
        Preconditions.checkNotNull(points, "Polyline points is null");
        for (Point point : points) {
            this.removePoint(point);
        }
        return this;
    }

    public Polyline removePoint(Collection<Point> points) {
        Preconditions.checkNotNull(points, "Polyline points is null");
        this.points.removeAll(points);
        return this;
    }

    public JsonObject toJson() {
        JsonObjectWrapper wrapper = new JsonObjectWrapper();
        wrapper.addProperty("key", this.getKey());
        wrapper.addProperty("points", new ArrayList<Point>(this.getPoints()));
        wrapper.addProperty("pane", this.getPane());
        return wrapper.getJsonObject();
    }

    public static Polyline fromJson(JsonObject obj) {
        Polyline polyline = Polyline.of(obj.get("key").getAsString(), new Point[0]);
        JsonElement el = obj.get("points");
        if (el != null && !(el instanceof JsonNull)) {
            JsonArray arr = el.getAsJsonArray();
            for (int i = 0; i < arr.size(); ++i) {
                polyline.addPoint(Point.fromJson((JsonObject)arr.get(i)));
            }
        }
        if ((el = obj.get("pane")) != null && !(el instanceof JsonNull)) {
            polyline.setPane(el.getAsString());
        }
        return polyline;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Polyline other = (Polyline)o;
        return this.getKey().equals(other.getKey()) && Objects.equals(this.getPoints(), other.getPoints()) && Objects.equals(this.getPane(), other.getPane()) && Objects.equals(this.getOptions(), other.getOptions());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getKey(), new ArrayList<Point>(this.getPoints()), this.getPane(), this.getOptions());
    }

    @Override
    public String toString() {
        return "Line{key=" + this.getKey() + ",points=" + String.valueOf(this.getPoints()) + ",pane=" + this.getPane() + ",options=" + String.valueOf(this.getOptions()) + "}";
    }
}

