/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.markers.marker;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.pl3x.map.core.markers.JsonObjectWrapper;
import net.pl3x.map.core.markers.Point;
import net.pl3x.map.core.markers.marker.Marker;
import net.pl3x.map.core.util.Preconditions;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class Rectangle
extends Marker<Rectangle> {
    private Point point1;
    private Point point2;

    private Rectangle(String key) {
        super("rect", key);
    }

    public Rectangle(String key, double x1, double z1, double x2, double z2) {
        this(key);
        this.setPoint1(Point.of(x1, z1));
        this.setPoint2(Point.of(x2, z2));
    }

    public Rectangle(String key, Point point1, Point point2) {
        this(key);
        this.setPoint1(point1);
        this.setPoint2(point2);
    }

    public static Rectangle of(String key, double x1, double z1, double x2, double z2) {
        return new Rectangle(key, x1, z1, x2, z2);
    }

    public static Rectangle of(String key, Point point1, Point point2) {
        return new Rectangle(key, point1, point2);
    }

    public Point getPoint1() {
        return this.point1;
    }

    public Rectangle setPoint1(Point point1) {
        this.point1 = Preconditions.checkNotNull(point1, "Rectangle point1 is null");
        return this;
    }

    public Point getPoint2() {
        return this.point2;
    }

    public Rectangle setPoint2(Point point2) {
        this.point2 = Preconditions.checkNotNull(point2, "Rectangle point2 is null");
        return this;
    }

    public JsonObject toJson() {
        JsonObjectWrapper wrapper = new JsonObjectWrapper();
        wrapper.addProperty("key", this.getKey());
        wrapper.addProperty("point1", this.getPoint1());
        wrapper.addProperty("point2", this.getPoint2());
        wrapper.addProperty("pane", this.getPane());
        return wrapper.getJsonObject();
    }

    public static Rectangle fromJson(JsonObject obj) {
        Rectangle rectangle = Rectangle.of(obj.get("key").getAsString(), Point.fromJson((JsonObject)obj.get("point1")), Point.fromJson((JsonObject)obj.get("point2")));
        JsonElement el = obj.get("pane");
        if (el != null && !(el instanceof JsonNull)) {
            rectangle.setPane(el.getAsString());
        }
        return rectangle;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Rectangle other = (Rectangle)o;
        return this.getKey().equals(other.getKey()) && this.getPoint1().equals(other.getPoint1()) && this.getPoint2().equals(other.getPoint2()) && Objects.equals(this.getPane(), other.getPane()) && Objects.equals(this.getOptions(), other.getOptions());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getKey(), this.getPoint1(), this.getPoint2(), this.getPane(), this.getOptions());
    }

    @Override
    public String toString() {
        return "Rectangle{key=" + this.getKey() + ",point1=" + String.valueOf(this.getPoint1()) + ",point2=" + String.valueOf(this.getPoint2()) + ",pane=" + this.getPane() + ",options=" + String.valueOf(this.getOptions()) + "}";
    }
}

