/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.markers.option;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.pl3x.map.core.markers.JsonObjectWrapper;
import net.pl3x.map.core.markers.JsonSerializable;
import net.pl3x.map.core.markers.Point;
import net.pl3x.map.core.markers.option.Fill;
import net.pl3x.map.core.markers.option.Option;
import net.pl3x.map.core.markers.option.Popup;
import net.pl3x.map.core.markers.option.Stroke;
import net.pl3x.map.core.markers.option.Tooltip;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class Options
implements JsonSerializable {
    private Stroke stroke;
    private Fill fill;
    private Tooltip tooltip;
    private Popup popup;

    public Options() {
    }

    public Options(@Nullable Stroke stroke, @Nullable Fill fill, @Nullable Tooltip tooltip, @Nullable Popup popup) {
        this.setStroke(stroke);
        this.setFill(fill);
        this.setTooltip(tooltip);
        this.setPopup(popup);
    }

    public static Builder builder() {
        return new Builder();
    }

    static <T extends Option<T>> @Nullable T parse(@Nullable T option) {
        return option == null || option.isDefault() ? null : (T)option;
    }

    public @Nullable Stroke getStroke() {
        return this.stroke;
    }

    public Options setStroke(@Nullable Stroke stroke) {
        this.stroke = Options.parse(stroke);
        return this;
    }

    public @Nullable Fill getFill() {
        return this.fill;
    }

    public Options setFill(@Nullable Fill fill) {
        this.fill = Options.parse(fill);
        return this;
    }

    public @Nullable Tooltip getTooltip() {
        return this.tooltip;
    }

    public Options setTooltip(@Nullable Tooltip tooltip) {
        this.tooltip = Options.parse(tooltip);
        return this;
    }

    public @Nullable Popup getPopup() {
        return this.popup;
    }

    public Options setPopup(@Nullable Popup popup) {
        this.popup = Options.parse(popup);
        return this;
    }

    public Builder asBuilder() {
        Builder builder = new Builder();
        if (this.getStroke() != null) {
            builder.stroke(Stroke.fromJson(this.getStroke().toJson()));
        }
        if (this.getFill() != null) {
            builder.fill(Fill.fromJson(this.getFill().toJson()));
        }
        if (this.getTooltip() != null) {
            builder.tooltip(Tooltip.fromJson(this.getTooltip().toJson()));
        }
        if (this.getPopup() != null) {
            builder.popup(Popup.fromJson(this.getPopup().toJson()));
        }
        return builder;
    }

    public JsonObject toJson() {
        JsonObjectWrapper wrapper = new JsonObjectWrapper();
        wrapper.addProperty("stroke", this.getStroke());
        wrapper.addProperty("fill", this.getFill());
        wrapper.addProperty("tooltip", this.getTooltip());
        wrapper.addProperty("popup", this.getPopup());
        return wrapper.getJsonObject();
    }

    public static Options fromJson(JsonObject obj) {
        Options options = new Options();
        JsonElement el = obj.get("stroke");
        if (el != null && !(el instanceof JsonNull)) {
            options.setStroke(Stroke.fromJson((JsonObject)el));
        }
        if ((el = obj.get("fill")) != null && !(el instanceof JsonNull)) {
            options.setFill(Fill.fromJson((JsonObject)el));
        }
        if ((el = obj.get("tooltip")) != null && !(el instanceof JsonNull)) {
            options.setTooltip(Tooltip.fromJson((JsonObject)el));
        }
        if ((el = obj.get("popup")) != null && !(el instanceof JsonNull)) {
            options.setPopup(Popup.fromJson((JsonObject)el));
        }
        return options;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Options other = (Options)o;
        return Objects.equals(this.getStroke(), other.getStroke()) && Objects.equals(this.getFill(), other.getFill()) && Objects.equals(this.getTooltip(), other.getTooltip()) && Objects.equals(this.getPopup(), other.getPopup());
    }

    public int hashCode() {
        return Objects.hash(this.getStroke(), this.getFill(), this.getTooltip(), this.getPopup());
    }

    public String toString() {
        return "Options{fill=" + String.valueOf(this.getFill()) + ",stroke=" + String.valueOf(this.getStroke()) + ",tooltip=" + String.valueOf(this.getTooltip()) + ",popup=" + String.valueOf(this.getPopup()) + "}";
    }

    public static class Builder {
        private Stroke stroke = null;
        private Fill fill = null;
        private Tooltip tooltip = null;
        private Popup popup = null;

        public Builder stroke(@Nullable Stroke stroke) {
            this.stroke = Options.parse(stroke);
            return this;
        }

        public Builder stroke(@Nullable Boolean enabled) {
            if (this.stroke == null) {
                this.stroke = new Stroke();
            }
            if (this.stroke.setEnabled(enabled).isDefault()) {
                this.stroke = null;
            }
            return this;
        }

        public Builder strokeWeight(@Nullable Integer weight) {
            if (this.stroke == null) {
                this.stroke = new Stroke();
            }
            if (this.stroke.setWeight(weight).isDefault()) {
                this.stroke = null;
            }
            return this;
        }

        public Builder strokeColor(@Nullable Integer color) {
            if (this.stroke == null) {
                this.stroke = new Stroke();
            }
            if (this.stroke.setColor(color).isDefault()) {
                this.stroke = null;
            }
            return this;
        }

        public Builder strokeLineCapShape(@Nullable Stroke.LineCapShape lineCapShape) {
            if (this.stroke == null) {
                this.stroke = new Stroke();
            }
            if (this.stroke.setLineCapShape(lineCapShape).isDefault()) {
                this.stroke = null;
            }
            return this;
        }

        public Builder strokeLineJoinShape(@Nullable Stroke.LineJoinShape lineJoinShape) {
            if (this.stroke == null) {
                this.stroke = new Stroke();
            }
            if (this.stroke.setLineJoinShape(lineJoinShape).isDefault()) {
                this.stroke = null;
            }
            return this;
        }

        public Builder strokeDashPattern(@Nullable String dashPattern) {
            if (this.stroke == null) {
                this.stroke = new Stroke();
            }
            if (this.stroke.setDashPattern(dashPattern).isDefault()) {
                this.stroke = null;
            }
            return this;
        }

        public Builder strokeDashOffset(@Nullable String dashOffset) {
            if (this.stroke == null) {
                this.stroke = new Stroke();
            }
            if (this.stroke.setDashOffset(dashOffset).isDefault()) {
                this.stroke = null;
            }
            return this;
        }

        public Builder fill(@Nullable Fill fill) {
            this.fill = Options.parse(fill);
            return this;
        }

        public Builder fill(@Nullable Boolean enabled) {
            if (this.fill == null) {
                this.fill = new Fill();
            }
            if (this.fill.setEnabled(enabled).isDefault()) {
                this.fill = null;
            }
            return this;
        }

        public Builder fillType(@Nullable Fill.Type type) {
            if (this.fill == null) {
                this.fill = new Fill();
            }
            if (this.fill.setType(type).isDefault()) {
                this.fill = null;
            }
            return this;
        }

        public Builder fillColor(@Nullable Integer color) {
            if (this.fill == null) {
                this.fill = new Fill();
            }
            if (this.fill.setColor(color).isDefault()) {
                this.fill = null;
            }
            return this;
        }

        public Builder tooltip(@Nullable Tooltip tooltip) {
            this.tooltip = Options.parse(tooltip);
            return this;
        }

        public Builder tooltipContent(@Nullable String content) {
            if (this.tooltip == null) {
                this.tooltip = new Tooltip();
            }
            if (this.tooltip.setContent(content).isDefault()) {
                this.tooltip = null;
            }
            return this;
        }

        public Builder tooltipPane(@Nullable String pane) {
            if (this.tooltip == null) {
                this.tooltip = new Tooltip();
            }
            if (this.tooltip.setPane(pane).isDefault()) {
                this.tooltip = null;
            }
            return this;
        }

        public Builder tooltipOffset(@Nullable Point offset) {
            if (this.tooltip == null) {
                this.tooltip = new Tooltip();
            }
            if (this.tooltip.setOffset(offset).isDefault()) {
                this.tooltip = null;
            }
            return this;
        }

        public Builder tooltipDirection(@Nullable Tooltip.Direction direction) {
            if (this.tooltip == null) {
                this.tooltip = new Tooltip();
            }
            if (this.tooltip.setDirection(direction).isDefault()) {
                this.tooltip = null;
            }
            return this;
        }

        public Builder tooltipPermanent(@Nullable Boolean permanent) {
            if (this.tooltip == null) {
                this.tooltip = new Tooltip();
            }
            if (this.tooltip.setPermanent(permanent).isDefault()) {
                this.tooltip = null;
            }
            return this;
        }

        public Builder tooltipSticky(@Nullable Boolean sticky) {
            if (this.tooltip == null) {
                this.tooltip = new Tooltip();
            }
            if (this.tooltip.setSticky(sticky).isDefault()) {
                this.tooltip = null;
            }
            return this;
        }

        public Builder tooltipOpacity(@Nullable Double opacity) {
            if (this.tooltip == null) {
                this.tooltip = new Tooltip();
            }
            if (this.tooltip.setOpacity(opacity).isDefault()) {
                this.tooltip = null;
            }
            return this;
        }

        public Builder popup(@Nullable Popup popup) {
            this.popup = Options.parse(popup);
            return this;
        }

        public Builder popupContent(@Nullable String content) {
            if (this.popup == null) {
                this.popup = new Popup();
            }
            if (this.popup.setContent(content).isDefault()) {
                this.popup = null;
            }
            return this;
        }

        public Builder popupPane(@Nullable String pane) {
            if (this.popup == null) {
                this.popup = new Popup();
            }
            if (this.popup.setPane(pane).isDefault()) {
                this.popup = null;
            }
            return this;
        }

        public Builder popupOffset(@Nullable Point offset) {
            if (this.popup == null) {
                this.popup = new Popup();
            }
            if (this.popup.setOffset(offset).isDefault()) {
                this.popup = null;
            }
            return this;
        }

        public Builder popupMaxWidth(@Nullable Integer maxWidth) {
            if (this.popup == null) {
                this.popup = new Popup();
            }
            if (this.popup.setMaxWidth(maxWidth).isDefault()) {
                this.popup = null;
            }
            return this;
        }

        public Builder popupMinWidth(@Nullable Integer minWidth) {
            if (this.popup == null) {
                this.popup = new Popup();
            }
            if (this.popup.setMinWidth(minWidth).isDefault()) {
                this.popup = null;
            }
            return this;
        }

        public Builder popupMaxHeight(@Nullable Integer maxHeight) {
            if (this.popup == null) {
                this.popup = new Popup();
            }
            if (this.popup.setMaxHeight(maxHeight).isDefault()) {
                this.popup = null;
            }
            return this;
        }

        public Builder popupShouldAutoPan(@Nullable Boolean autoPan) {
            if (this.popup == null) {
                this.popup = new Popup();
            }
            if (this.popup.setShouldAutoPan(autoPan).isDefault()) {
                this.popup = null;
            }
            return this;
        }

        public Builder popupAutoPanPaddingTopLeft(@Nullable Point autoPanPaddingTopLeft) {
            if (this.popup == null) {
                this.popup = new Popup();
            }
            if (this.popup.setAutoPanPaddingTopLeft(autoPanPaddingTopLeft).isDefault()) {
                this.popup = null;
            }
            return this;
        }

        public Builder popupAutoPanPaddingBottomRight(@Nullable Point autoPanPaddingBottomRight) {
            if (this.popup == null) {
                this.popup = new Popup();
            }
            if (this.popup.setAutoPanPaddingBottomRight(autoPanPaddingBottomRight).isDefault()) {
                this.popup = null;
            }
            return this;
        }

        public Builder popupAutoPanPadding(@Nullable Point autoPanPadding) {
            if (this.popup == null) {
                this.popup = new Popup();
            }
            if (this.popup.setAutoPanPadding(autoPanPadding).isDefault()) {
                this.popup = null;
            }
            return this;
        }

        public Builder popupShouldKeepInView(@Nullable Boolean keepInView) {
            if (this.popup == null) {
                this.popup = new Popup();
            }
            if (this.popup.setShouldKeepInView(keepInView).isDefault()) {
                this.popup = null;
            }
            return this;
        }

        public Builder popupCloseButton(@Nullable Boolean closeButton) {
            if (this.popup == null) {
                this.popup = new Popup();
            }
            if (this.popup.setCloseButton(closeButton).isDefault()) {
                this.popup = null;
            }
            return this;
        }

        public Builder popupShouldAutoClose(@Nullable Boolean autoClose) {
            if (this.popup == null) {
                this.popup = new Popup();
            }
            if (this.popup.setShouldAutoClose(autoClose).isDefault()) {
                this.popup = null;
            }
            return this;
        }

        public Builder popupShouldCloseOnEscapeKey(@Nullable Boolean closeOnEscapeKey) {
            if (this.popup == null) {
                this.popup = new Popup();
            }
            if (this.popup.setShouldCloseOnEscapeKey(closeOnEscapeKey).isDefault()) {
                this.popup = null;
            }
            return this;
        }

        public Builder popupShouldCloseOnClick(@Nullable Boolean closeOnClick) {
            if (this.popup == null) {
                this.popup = new Popup();
            }
            if (this.popup.setShouldCloseOnClick(closeOnClick).isDefault()) {
                this.popup = null;
            }
            return this;
        }

        public Options build() {
            return new Options(this.stroke, this.fill, this.tooltip, this.popup);
        }
    }
}

