/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.markers.option;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.pl3x.map.core.markers.JsonObjectWrapper;
import net.pl3x.map.core.markers.Point;
import net.pl3x.map.core.markers.option.Option;
import net.pl3x.map.core.util.Mathf;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class Tooltip
extends Option<Tooltip> {
    public static final Point DEFAULT_OFFSET = Point.ZERO;
    private String content;
    private String pane;
    private Point offset;
    private Direction direction;
    private Boolean permanent;
    private Boolean sticky;
    private Double opacity;

    public Tooltip() {
    }

    public Tooltip(@Nullable String string) {
        this.setContent(string);
    }

    public @Nullable String getContent() {
        return this.content;
    }

    public Tooltip setContent(@Nullable String content) {
        this.content = content;
        return this;
    }

    public @Nullable String getPane() {
        return this.pane;
    }

    public Tooltip setPane(@Nullable String pane) {
        this.pane = pane;
        return this;
    }

    public @Nullable Point getOffset() {
        return this.offset;
    }

    public Tooltip setOffset(@Nullable Point offset) {
        this.offset = offset;
        return this;
    }

    public @Nullable Direction getDirection() {
        return this.direction;
    }

    public Tooltip setDirection(@Nullable Direction direction) {
        this.direction = direction;
        return this;
    }

    public @Nullable Boolean isPermanent() {
        return this.permanent;
    }

    public Tooltip setPermanent(@Nullable Boolean permanent) {
        this.permanent = permanent;
        return this;
    }

    public @Nullable Boolean isSticky() {
        return this.sticky;
    }

    public Tooltip setSticky(@Nullable Boolean sticky) {
        this.sticky = sticky;
        return this;
    }

    public @Nullable Double getOpacity() {
        return this.opacity;
    }

    public Tooltip setOpacity(@Nullable Double opacity) {
        this.opacity = opacity == null ? null : Double.valueOf(Mathf.clamp(0.0, 1.0, opacity));
        return this;
    }

    @Override
    public boolean isDefault() {
        return !(this.getContent() != null || this.getPane() != null && !this.getPane().equals("tooltipPane") || this.getOffset() != null && !this.getOffset().equals(DEFAULT_OFFSET) || this.getDirection() != null && this.getDirection() != Direction.AUTO || this.isPermanent() != null && !Boolean.FALSE.equals(this.isPermanent()) || this.isSticky() != null && !Boolean.FALSE.equals(this.isSticky()) || this.getOpacity() != null && this.getOpacity() != 0.9);
    }

    public JsonObject toJson() {
        JsonObjectWrapper wrapper = new JsonObjectWrapper();
        wrapper.addProperty("content", this.getContent());
        wrapper.addProperty("pane", this.getPane());
        wrapper.addProperty("offset", this.getOffset());
        wrapper.addProperty("direction", this.getDirection());
        wrapper.addProperty("permanent", this.isPermanent());
        wrapper.addProperty("sticky", this.isSticky());
        wrapper.addProperty("opacity", this.getOpacity());
        return wrapper.getJsonObject();
    }

    public static Tooltip fromJson(JsonObject obj) {
        Tooltip tooltip = new Tooltip();
        JsonElement el = obj.get("content");
        if (el != null && !(el instanceof JsonNull)) {
            tooltip.setContent(el.getAsString());
        }
        if ((el = obj.get("pane")) != null && !(el instanceof JsonNull)) {
            tooltip.setPane(el.getAsString());
        }
        if ((el = obj.get("offset")) != null && !(el instanceof JsonNull)) {
            tooltip.setOffset(Point.fromJson((JsonObject)el));
        }
        if ((el = obj.get("direction")) != null && !(el instanceof JsonNull)) {
            tooltip.setDirection(Direction.values()[el.getAsInt()]);
        }
        if ((el = obj.get("permanent")) != null && !(el instanceof JsonNull)) {
            tooltip.setPermanent(el.getAsBoolean());
        }
        if ((el = obj.get("sticky")) != null && !(el instanceof JsonNull)) {
            tooltip.setSticky(el.getAsBoolean());
        }
        if ((el = obj.get("opacity")) != null && !(el instanceof JsonNull)) {
            tooltip.setOpacity(el.getAsDouble());
        }
        return tooltip;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Tooltip other = (Tooltip)o;
        return Objects.equals(this.getContent(), other.getContent()) && Objects.equals(this.getPane(), other.getPane()) && Objects.equals(this.getOffset(), other.getOffset()) && Objects.equals((Object)this.getDirection(), (Object)other.getDirection()) && Objects.equals(this.isPermanent(), other.isPermanent()) && Objects.equals(this.isSticky(), other.isSticky()) && Objects.equals(this.getOpacity(), other.getOpacity());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getContent(), this.getPane(), this.getOffset(), this.getDirection(), this.isPermanent(), this.isSticky(), this.getOpacity()});
    }

    public String toString() {
        return "Tooltip{,content=" + this.getContent() + ",pane=" + this.getPane() + ",offset=" + String.valueOf(this.getOffset()) + ",direction=" + String.valueOf((Object)this.getDirection()) + ",permanent=" + this.isPermanent() + ",sticky=" + this.isSticky() + ",opacity=" + this.getOpacity() + "}";
    }

    public static enum Direction {
        RIGHT,
        LEFT,
        TOP,
        BOTTOM,
        CENTER,
        AUTO;

    }
}

