/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.registry;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.management.openmbean.KeyAlreadyExistsException;
import net.pl3x.map.core.registry.Registry;
import net.pl3x.map.core.util.FileUtil;
import net.pl3x.map.core.world.Biome;
import net.pl3x.map.core.world.World;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class BiomeRegistry
extends Registry<Biome> {
    private static final Gson GSON = new GsonBuilder().create();
    public static final int MAX_INDEX = 511;
    private final Map<String, Integer> indexMap = new HashMap<String, Integer>();
    private int lastIndex = 0;

    public void init(World world) {
        Path file = world.getTilesDirectory().resolve("biomes.gz");
        if (!Files.exists(file, new LinkOption[0])) {
            return;
        }
        try {
            TypeToken<Map<Integer, String>> token = new TypeToken<Map<Integer, String>>(this){};
            this.indexMap.putAll(((Map)GSON.fromJson(FileUtil.readGzip(file), (TypeToken)token)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private int getNextIndex(String id) {
        if (this.size() > 511) {
            return -1;
        }
        int index = this.indexMap.getOrDefault(id, -1);
        if (index > -1) {
            return index;
        }
        while (true) {
            if (!this.indexMap.containsValue(this.lastIndex)) {
                this.indexMap.put(id, this.lastIndex);
                return this.lastIndex;
            }
            ++this.lastIndex;
        }
    }

    public Biome register(String id, int color, int dryFoliage, int foliage, int grass, int water, Biome.GrassModifier grassModifier) {
        if (this.has(id)) {
            throw new KeyAlreadyExistsException("Biome already registered: " + id);
        }
        return this.register(id, new Biome(this.getNextIndex(id), id, color, dryFoliage, foliage, grass, water, grassModifier));
    }

    @Override
    public @Nullable Biome get(String id) {
        return this.getOrDefault(id, Biome.DEFAULT);
    }

    public void saveToDisk(World world) {
        HashMap map = new HashMap();
        this.values().forEach(biome -> map.put(biome.index(), biome.getKey()));
        try {
            FileUtil.saveGzip(GSON.toJson(map), world.getTilesDirectory().resolve("biomes.gz"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

