/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.renderer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.pl3x.map.core.markers.Point;
import net.pl3x.map.core.renderer.Renderer;
import net.pl3x.map.core.renderer.task.RegionScanTask;
import net.pl3x.map.core.util.ByteUtil;
import net.pl3x.map.core.util.FileUtil;
import net.pl3x.map.core.util.Mathf;
import net.pl3x.map.core.world.Biome;
import net.pl3x.map.core.world.Block;
import net.pl3x.map.core.world.Blocks;
import net.pl3x.map.core.world.Chunk;
import net.pl3x.map.core.world.Region;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class BlockInfoRenderer
extends Renderer {
    private static final Map<Path, ReadWriteLock> FILE_LOCKS = new ConcurrentHashMap<Path, ReadWriteLock>();
    private ByteBuffer byteBuffer;

    public BlockInfoRenderer(RegionScanTask task, Renderer.Builder builder) {
        super(task, builder);
    }

    @Override
    public void allocateData(Point region) {
        this.byteBuffer = ByteBuffer.allocate(0x10000C);
        Path path = this.getWorld().getTilesDirectory().resolve(String.format("%d/%s/", 0, this.getKey())).resolve(String.format("%d_%d.%s", region.x(), region.z(), "pl3xmap.gz"));
        try {
            if (Files.exists(path, new LinkOption[0]) && Files.size(path) > 0L) {
                FileUtil.readGzip(path, this.byteBuffer);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void saveData(Point region) {
        Path tilesDir = this.getWorld().getTilesDirectory();
        for (int zoom = 0; zoom <= this.getWorld().getConfig().ZOOM_MAX_OUT; ++zoom) {
            Path dirPath = tilesDir.resolve(String.format("%d/%s/", zoom, this.getKey()));
            FileUtil.createDirs(dirPath);
            int step = Mathf.pow2(zoom);
            int size = 512 / step;
            Path filePath = dirPath.resolve(String.format("%d_%d.%s", (int)Math.floor((double)region.x() / (double)step), (int)Math.floor((double)region.z() / (double)step), "pl3xmap.gz"));
            ReadWriteLock lock = FILE_LOCKS.computeIfAbsent(filePath, k -> new ReentrantReadWriteLock(true));
            lock.writeLock().lock();
            IOException error = null;
            if (zoom == 0) {
                try {
                    FileUtil.saveGzip(this.byteBuffer.array(), filePath);
                }
                catch (IOException e) {
                    error = e;
                }
            } else {
                try {
                    ByteBuffer buffer = ByteBuffer.allocate(this.byteBuffer.capacity());
                    if (Files.exists(filePath, new LinkOption[0]) && Files.size(filePath) > 0L) {
                        try {
                            FileUtil.readGzip(filePath, buffer);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    for (int i = 0; i < 12; ++i) {
                        buffer.put(i, this.byteBuffer.get(i));
                    }
                    int baseX = region.x() * size & 0x1FF;
                    int baseZ = region.z() * size & 0x1FF;
                    for (int x = 0; x < 512; x += step) {
                        for (int z = 0; z < 512; z += step) {
                            int index = z * 512 + x;
                            int packed = ByteUtil.getInt(this.byteBuffer, 12 + index * 4);
                            int newIndex = (baseZ + z / step) * 512 + (baseX + x / step);
                            buffer.put(12 + newIndex * 4, ByteUtil.toBytes(packed));
                        }
                    }
                    FileUtil.saveGzip(buffer.array(), filePath);
                }
                catch (IOException e) {
                    error = e;
                }
            }
            lock.writeLock().unlock();
            if (error == null) continue;
            throw new RuntimeException(error);
        }
    }

    @Override
    public void scanData(Region region) {
        this.byteBuffer.clear();
        this.byteBuffer.put(0, ByteUtil.toBytes(1886139256));
        this.byteBuffer.put(4, ByteUtil.toBytes(1835102209));
        this.byteBuffer.put(8, ByteUtil.toBytes(this.getWorld().getMinBuildHeight()));
        super.scanData(region);
    }

    @Override
    public void scanBlock(Region region, Chunk chunk, Chunk.BlockData data, int blockX, int blockZ) {
        boolean fluid = data.getFluidState() != null;
        int y = (fluid ? data.getFluidY() : data.getBlockY()) - this.getWorld().getMinBuildHeight();
        Block block = (fluid ? data.getFluidState() : data.getBlockState()).getBlock();
        Biome biome = data.getBiome(region, blockX, blockZ);
        int blockIndex = block.getIndex() == -1 ? Blocks.AIR.getIndex() : block.getIndex();
        int biomeIndex = biome.index() == -1 ? Biome.DEFAULT.index() : biome.index();
        int packed = (blockIndex & 0x7FF) << 21 | (biomeIndex & 0x1FF) << 12 | y & 0xFFF;
        int index = (blockZ & 0x1FF) * 512 + (blockX & 0x1FF);
        this.byteBuffer.put(12 + index * 4, ByteUtil.toBytes(packed));
    }
}

