/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.renderer;

import java.util.HashMap;
import java.util.Map;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.renderer.Renderer;
import net.pl3x.map.core.renderer.task.RegionScanTask;
import net.pl3x.map.core.util.Colors;
import net.pl3x.map.core.world.Biome;
import net.pl3x.map.core.world.Block;
import net.pl3x.map.core.world.Blocks;
import net.pl3x.map.core.world.Chunk;
import net.pl3x.map.core.world.Region;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class FlowerMapRenderer
extends Renderer {
    private final Map<Block, Integer> colorMap = new HashMap<Block, Integer>();

    public FlowerMapRenderer(RegionScanTask task, Renderer.Builder builder) {
        super(task, builder);
        this.colorMap.put(Blocks.DANDELION, 0xFFFF00);
        this.colorMap.put(Blocks.POPPY, 0xFF0000);
        this.colorMap.put(Blocks.ALLIUM, 0x9900FF);
        this.colorMap.put(Blocks.AZURE_BLUET, 0xFFFDDD);
        this.colorMap.put(Blocks.RED_TULIP, 16731490);
        this.colorMap.put(Blocks.ORANGE_TULIP, 16758106);
        this.colorMap.put(Blocks.WHITE_TULIP, 0xDDFFFF);
        this.colorMap.put(Blocks.PINK_TULIP, 16102655);
        this.colorMap.put(Blocks.OXEYE_DAISY, 0xFFEEDD);
        this.colorMap.put(Blocks.CORNFLOWER, 4260095);
        this.colorMap.put(Blocks.LILY_OF_THE_VALLEY, 0xFFFFFF);
        this.colorMap.put(Blocks.BLUE_ORCHID, 49151);
        this.colorMap.put(Blocks.PINK_PETALS, 16728511);
        this.colorMap.put(Blocks.CLOSED_EYEBLOSSOM, 8339200);
    }

    @Override
    public void scanBlock(Region region, Chunk chunk, Chunk.BlockData data, int blockX, int blockZ) {
        int pixelColor = 0x7F7F7F;
        Biome biome = data.getBiome(region, blockX, blockZ);
        Block flower = Pl3xMap.api().getFlower(region.getWorld(), biome, blockX, data.getBlockY(), blockZ);
        if (flower != null) {
            pixelColor = 0xFF000000 | this.colorMap.getOrDefault(flower, pixelColor) & 0xFFFFFF;
        }
        pixelColor = Colors.blend(this.getHeightmap().getColor(region, blockX, blockZ), pixelColor);
        pixelColor = this.processFluids(this.getWorld().getConfig().RENDER_TRANSLUCENT_FLUIDS, region, biome, data, blockX, blockZ, pixelColor);
        this.getTileImage().setPixel(blockX, blockZ, pixelColor);
    }
}

