/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.renderer;

import net.pl3x.map.core.renderer.Renderer;
import net.pl3x.map.core.renderer.task.RegionScanTask;
import net.pl3x.map.core.util.Colors;
import net.pl3x.map.core.util.Mathf;
import net.pl3x.map.core.world.Chunk;
import net.pl3x.map.core.world.Region;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class InhabitedRenderer
extends Renderer {
    private Renderer basic;

    public InhabitedRenderer(RegionScanTask task, Renderer.Builder builder) {
        super(task, builder);
    }

    @Override
    public void scanData(Region region) {
        this.basic = this.getRegionScanTask().getRenderer("basic");
        super.scanData(region);
    }

    @Override
    public void scanBlock(Region region, Chunk chunk, Chunk.BlockData data, int blockX, int blockZ) {
        int pixelColor = this.basic != null ? this.basic.getTileImage().getPixel(blockX, blockZ) : this.basicPixelColor(region, data, blockX, blockZ);
        float ratio = Mathf.clamp(0.0f, 1.0f, (float)chunk.getInhabitedTime() / 3600000.0f);
        int inhabitedRGB = Colors.lerpHSB(-2013265665, -1996554240, ratio, false);
        pixelColor = Colors.blend(inhabitedRGB, pixelColor);
        this.getTileImage().setPixel(blockX, blockZ, pixelColor);
    }
}

