/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.renderer;

import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.renderer.Renderer;
import net.pl3x.map.core.renderer.heightmap.Heightmap;
import net.pl3x.map.core.renderer.task.RegionScanTask;
import net.pl3x.map.core.util.Colors;
import net.pl3x.map.core.world.BlockState;
import net.pl3x.map.core.world.Chunk;
import net.pl3x.map.core.world.EmptyChunk;
import net.pl3x.map.core.world.Region;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class VanillaRenderer
extends Renderer {
    private final Heightmap heightmap = (Heightmap)Pl3xMap.api().getHeightmapRegistry().get("old_school");

    public VanillaRenderer(RegionScanTask task, Renderer.Builder builder) {
        super(task, builder);
    }

    @Override
    public Heightmap getHeightmap() {
        return this.heightmap;
    }

    @Override
    public void scanData(Region region) {
        int startX = region.getX() << 9;
        int startZ = region.getZ() << 9;
        for (int pixelX = 0; pixelX < 512; ++pixelX) {
            int blockX = startX + pixelX;
            double lastBlockY = 0.0;
            for (int pixelZ = -1; pixelZ < 512; ++pixelZ) {
                BlockState blockstate;
                int blockZ = startZ + pixelZ;
                if (!this.getWorld().visibleBlock(blockX, blockZ)) continue;
                Pl3xMap.api().getRegionProcessor().checkPaused();
                Chunk chunk = region.getWorld().getChunk(region, blockX >> 4, blockZ >> 4);
                if (chunk instanceof EmptyChunk) continue;
                int blockY = chunk.noHeightmap() ? this.getWorld().getMaxBuildHeight() : chunk.getWorldSurfaceY(blockX, blockZ) + 1;
                int fluidY = 0;
                BlockState fluidstate = null;
                blockY = this.getBlockBelowCeiling(blockY, chunk, blockX, blockZ);
                do {
                    if ((blockstate = chunk.getBlockState(blockX, --blockY, blockZ)).getBlock().isFluid()) {
                        if (fluidstate != null) continue;
                        fluidY = blockY;
                        fluidstate = blockstate;
                        continue;
                    }
                    if (blockstate.getBlock().vanilla() > 0) break;
                } while (blockY > this.getWorld().getMinBuildHeight());
                this.setPixel(pixelZ, fluidstate, fluidY, blockY, pixelX, blockstate, lastBlockY);
                if (blockstate.getBlock().isFlat()) {
                    --blockY;
                }
                lastBlockY = blockY;
            }
        }
    }

    private void setPixel(int pixelZ, @Nullable BlockState fluidstate, int fluidY, int blockY, int pixelX, BlockState blockstate, double lastBlockY) {
        if (pixelZ >= 0) {
            int brightness;
            int color;
            if (fluidstate != null) {
                color = fluidstate.getBlock().vanilla();
                double heightDiff = (double)(fluidY - blockY) * 0.1 + (double)(pixelX + pixelZ & 1) * 0.2;
                brightness = heightDiff < 0.5 ? 0 : (heightDiff > 0.9 ? 68 : 34);
            } else {
                color = blockstate.getBlock().vanilla();
                double heightDiff = ((double)blockY - lastBlockY) * 4.0 / 5.0 + ((double)(pixelX + pixelZ & 1) - 0.5) * 0.4;
                brightness = heightDiff > 0.6 ? 0 : (heightDiff < -0.6 ? 68 : 34);
            }
            this.getTileImage().setPixel(pixelX, pixelZ, Colors.blend(brightness << 24, Colors.setAlpha(255, color)));
        }
    }

    protected int getBlockBelowCeiling(int blockY, Chunk chunk, int blockX, int blockZ) {
        if (this.getWorld().hasCeiling()) {
            BlockState blockstate;
            blockY = this.getWorld().getLogicalHeight();
            do {
                blockstate = chunk.getBlockState(blockX, --blockY, blockZ);
            } while (blockY > this.getWorld().getMinBuildHeight() && !blockstate.getBlock().isAir());
        }
        return blockY;
    }

    @Override
    public void scanBlock(Region region, Chunk chunk, Chunk.BlockData data, int blockX, int blockZ) {
    }
}

