/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class StringUtils {
    public static @Nullable String unescapeJava(@Nullable String str) {
        if (str == null) {
            return null;
        }
        try {
            StringWriter writer = new StringWriter(str.length());
            StringUtils.unescapeJava(writer, str);
            return writer.toString();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private static void unescapeJava(@Nullable Writer out, @Nullable String str) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("The Writer must not be null");
        }
        if (str == null) {
            return;
        }
        int sz = str.length();
        StringBuilder unicode = new StringBuilder(4);
        boolean hadSlash = false;
        boolean inUnicode = false;
        for (int i = 0; i < sz; ++i) {
            char ch = str.charAt(i);
            if (inUnicode) {
                unicode.append(ch);
                if (unicode.length() != 4) continue;
                try {
                    int value = Integer.parseInt(unicode.toString(), 16);
                    out.write((char)value);
                    unicode.setLength(0);
                    inUnicode = false;
                    hadSlash = false;
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new RuntimeException("Unable to parse unicode value: " + String.valueOf(unicode), nfe);
                }
            }
            if (hadSlash) {
                hadSlash = false;
                inUnicode = StringUtils.handleSlash(out, ch, inUnicode);
                continue;
            }
            if (ch == '\\') {
                hadSlash = true;
                continue;
            }
            out.write(ch);
        }
        if (hadSlash) {
            out.write(92);
        }
    }

    private static boolean handleSlash(Writer out, char ch, boolean inUnicode) throws IOException {
        switch (ch) {
            case '\\': {
                out.write(92);
                break;
            }
            case '\'': {
                out.write(39);
                break;
            }
            case '\"': {
                out.write(34);
                break;
            }
            case 'r': {
                out.write(13);
                break;
            }
            case 'f': {
                out.write(12);
                break;
            }
            case 't': {
                out.write(9);
                break;
            }
            case 'n': {
                out.write(10);
                break;
            }
            case 'b': {
                out.write(8);
                break;
            }
            case 'u': {
                inUnicode = true;
                break;
            }
            default: {
                out.write(ch);
            }
        }
        return inUnicode;
    }
}

