/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.world;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import libs.net.querz.nbt.tag.ByteTag;
import libs.net.querz.nbt.tag.CompoundTag;
import libs.net.querz.nbt.tag.IntTag;
import libs.net.querz.nbt.tag.Tag;
import net.pl3x.map.core.util.Colors;
import net.pl3x.map.core.world.Biome;
import net.pl3x.map.core.world.BlockState;
import net.pl3x.map.core.world.ChunkAnvil113;
import net.pl3x.map.core.world.ChunkAnvil115;
import net.pl3x.map.core.world.ChunkAnvil116;
import net.pl3x.map.core.world.ChunkAnvil118;
import net.pl3x.map.core.world.EmptyChunk;
import net.pl3x.map.core.world.Region;
import net.pl3x.map.core.world.World;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public abstract class Chunk {
    private final World world;
    private final Region region;
    private final int xPos;
    private final int yPos;
    private final int zPos;
    private final long inhabitedTime;
    protected final BlockData[] data = new BlockData[256];
    protected boolean populated;

    protected Chunk(World world, Region region) {
        this.world = world;
        this.region = region;
        this.xPos = 0;
        this.yPos = 0;
        this.zPos = 0;
        this.inhabitedTime = 0L;
    }

    protected Chunk(World world, Region region, CompoundTag tag, int index) {
        this.world = world;
        this.region = region;
        this.xPos = this.pos(tag.get("xPos"), () -> (region.getX() << 5) + (index & 0x1F));
        this.yPos = this.pos(tag.get("yPos"), () -> world.getMinBuildHeight() >> 4);
        this.zPos = this.pos(tag.get("zPos"), () -> (region.getZ() << 5) + (index << 5));
        this.inhabitedTime = tag.getLong("InhabitedTime");
    }

    private int pos(Tag<?> tag, Supplier<Integer> failsafe) {
        if (tag instanceof IntTag) {
            IntTag intTag = (IntTag)tag;
            return intTag.asInt();
        }
        if (tag instanceof ByteTag) {
            ByteTag byteTag = (ByteTag)tag;
            return byteTag.asInt();
        }
        return failsafe.get();
    }

    public World getWorld() {
        return this.world;
    }

    public Region getRegion() {
        return this.region;
    }

    public int getX() {
        return this.xPos;
    }

    public int getY() {
        return this.yPos;
    }

    public int getZ() {
        return this.zPos;
    }

    public long getInhabitedTime() {
        return this.inhabitedTime;
    }

    public abstract boolean isFull();

    public abstract boolean noHeightmap();

    public abstract int getWorldSurfaceY(int var1, int var2);

    public abstract BlockState getBlockState(int var1, int var2, int var3);

    public abstract int getLight(int var1, int var2, int var3);

    public abstract Biome getBiome(int var1, int var2, int var3);

    public Chunk populate() {
        if (this.populated) {
            return this;
        }
        int startX = this.getX() << 4;
        int startZ = this.getZ() << 4;
        for (int blockZ = startX; blockZ < startX + 16; ++blockZ) {
            for (int blockX = startZ; blockX < startZ + 16; ++blockX) {
                BlockData data = new BlockData();
                int n = data.blockY = this.noHeightmap() ? this.getWorld().getMaxBuildHeight() : this.getWorldSurfaceY(blockX, blockZ) + 1;
                if (this.getWorld().hasCeiling()) {
                    data.blockY = this.getWorld().getLogicalHeight();
                    do {
                        --data.blockY;
                        data.blockstate = this.getBlockState(blockX, data.blockY, blockZ);
                    } while (data.blockY > this.getWorld().getMinBuildHeight() && !data.blockstate.getBlock().isAir());
                }
                do {
                    --data.blockY;
                    data.blockstate = this.getBlockState(blockX, data.blockY, blockZ);
                    if (data.blockstate.getBlock().isFluid()) {
                        if (data.fluidstate != null) continue;
                        data.fluidY = data.blockY;
                        data.fluidstate = data.blockstate;
                        continue;
                    }
                    if (this.getWorld().getConfig().RENDER_TRANSLUCENT_GLASS && data.blockstate.getBlock().isGlass()) {
                        data.glass.addFirst(Colors.setAlpha(153, data.blockstate.getBlock().color()));
                        continue;
                    }
                    if (data.blockstate.getBlock().color() > 0) break;
                } while (data.blockY > this.getWorld().getMinBuildHeight());
                if (data.blockstate.getBlock().isFlat()) {
                    --data.blockY;
                }
                this.data[((blockZ & 0xF) << 4) + (blockX & 0xF)] = data;
            }
        }
        this.populated = true;
        return this;
    }

    public BlockData[] getData() {
        return this.data;
    }

    public @Nullable BlockData getData(int x, int z) {
        return this.data[((z & 0xF) << 4) + (x & 0xF)];
    }

    public static Chunk create(World world, Region region, CompoundTag tag, int index) {
        int version = tag.getInt("DataVersion");
        Chunk chunk = version < 1519 ? new EmptyChunk(world, region) : (version < 2200 ? new ChunkAnvil113(world, region, tag, index) : (version < 2500 ? new ChunkAnvil115(world, region, tag, index) : (version < 2844 ? new ChunkAnvil116(world, region, tag, index) : new ChunkAnvil118(world, region, tag, index))));
        return chunk.isFull() ? chunk : new EmptyChunk(world, region);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Chunk other = (Chunk)o;
        return this.getWorld().equals(other.getWorld()) && this.getX() == other.getX() && this.getY() == other.getY() && this.getZ() == other.getZ();
    }

    public int hashCode() {
        return Objects.hash(this.getWorld(), this.getX(), this.getY(), this.getZ());
    }

    public String toString() {
        return "Chunk{world=" + String.valueOf(this.getWorld()) + ",xPos=" + this.getX() + ",yPos=" + this.getY() + ",zPos=" + this.getZ() + "}";
    }

    public static class BlockData {
        protected int blockY;
        protected int fluidY = 0;
        protected BlockState blockstate;
        protected BlockState fluidstate = null;
        protected Biome biome;
        protected LinkedList<Integer> glass = new LinkedList();

        public static BlockData of(int blockY, int fluidY, BlockState blockstate, BlockState fluidstate, LinkedList<Integer> glass) {
            BlockData data = new BlockData();
            data.blockY = blockY;
            data.fluidY = fluidY;
            data.blockstate = blockstate;
            data.fluidstate = fluidstate;
            data.glass = glass;
            return data;
        }

        public int getBlockY() {
            return this.blockY;
        }

        public int getFluidY() {
            return this.fluidY;
        }

        public BlockState getBlockState() {
            return this.blockstate;
        }

        public @Nullable BlockState getFluidState() {
            return this.fluidstate;
        }

        public Biome getBiome(Region region, int x, int z) {
            if (this.biome == null) {
                int y = this.blockY;
                if (this.fluidstate != null) {
                    y = this.fluidY;
                }
                this.biome = region.getWorld().getBiomeManager().getBiome(region, x, y, z);
            }
            return this.biome;
        }

        public List<Integer> getGlassColors() {
            return this.glass;
        }
    }
}

