/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.world;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.file.Path;
import java.util.Objects;
import libs.net.jpountz.lz4.LZ4BlockInputStream;
import libs.net.querz.mca.CompressionType;
import libs.net.querz.nbt.io.NBTInputStream;
import libs.net.querz.nbt.io.NamedTag;
import libs.net.querz.nbt.tag.CompoundTag;
import libs.net.querz.nbt.tag.Tag;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.log.Logger;
import net.pl3x.map.core.world.Chunk;
import net.pl3x.map.core.world.EmptyChunk;
import net.pl3x.map.core.world.World;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class Region {
    private final World world;
    private final int regionX;
    private final int regionZ;
    private final File regionFile;
    private final Chunk[] chunks = new Chunk[1024];
    private final int hash;

    public Region(World world, int regionX, int regionZ, Path regionFile) {
        this.world = world;
        this.regionX = regionX;
        this.regionZ = regionZ;
        this.regionFile = regionFile.toFile();
        this.hash = Objects.hash(world, regionX, regionZ);
    }

    public World getWorld() {
        return this.world;
    }

    public int getX() {
        return this.regionX;
    }

    public int getZ() {
        return this.regionZ;
    }

    public File getRegionFile() {
        return this.regionFile;
    }

    private int getChunkIndex(int chunkX, int chunkZ) {
        return (chunkX & 0x1F) + ((chunkZ & 0x1F) << 5);
    }

    public Chunk getChunk(int chunkX, int chunkZ) {
        int index = this.getChunkIndex(chunkX, chunkZ);
        Chunk chunk = this.chunks[index];
        if (chunk == null) {
            try (RandomAccessFile raf2 = new RandomAccessFile(this.getRegionFile(), "r");){
                chunk = this.loadChunk(raf2, index);
            }
            catch (EOFException | FileNotFoundException raf2) {
            }
            catch (IOException e) {
                Logger.severe("Failed to load chunk at region [%d, %d]".formatted(chunkX, chunkZ), e);
            }
            if (chunk == null) {
                this.chunks[index] = new EmptyChunk(this.getWorld(), this);
                return this.chunks[index];
            }
        }
        return chunk;
    }

    public void loadChunks() throws IOException {
        if (!this.getRegionFile().exists() || this.getRegionFile().length() <= 0L) {
            return;
        }
        try (RandomAccessFile raf = new RandomAccessFile(this.getRegionFile(), "r");){
            for (int index = 0; index < this.chunks.length; ++index) {
                Pl3xMap.api().getRegionProcessor().checkPaused();
                this.loadChunk(raf, index);
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    public Chunk loadChunk(RandomAccessFile raf, int index) throws IOException {
        Tag<?> tag;
        raf.seek((long)index * 4L);
        int offset = raf.read() << 16;
        offset |= (raf.read() & 0xFF) << 8;
        offset |= raf.read() & 0xFF;
        if (raf.readByte() == 0) {
            this.chunks[index] = new EmptyChunk(this.getWorld(), this);
            return this.chunks[index];
        }
        raf.seek(4096L * (long)offset + 4L);
        byte compressionTypeByte = raf.readByte();
        CompressionType compressionType = CompressionType.getFromID(compressionTypeByte);
        if (compressionType == null && compressionTypeByte == 3) {
            compressionType = CompressionType.NONE;
        }
        if (compressionTypeByte != 4 && compressionType == null) {
            throw new IOException("Invalid compression type " + compressionTypeByte);
        }
        FileInputStream fileInputStream = new FileInputStream(raf.getFD());
        InputStream decompress = compressionTypeByte == 4 ? new LZ4BlockInputStream(fileInputStream) : compressionType.decompress(fileInputStream);
        DataInputStream dis = new DataInputStream(new BufferedInputStream(decompress));
        NamedTag tag2 = new NBTInputStream(dis).readTag(512);
        if (tag2 != null && (tag = tag2.getTag()) instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            this.chunks[index] = Chunk.create(this.getWorld(), this, compoundTag, index).populate();
            return this.chunks[index];
        }
        throw new IOException("Invalid data tag: " + (tag2 == null ? "null" : tag2.getName()));
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Region other = (Region)o;
        return this.getWorld().equals(other.getWorld()) && this.getX() == other.getX() && this.getZ() == other.getZ();
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return "Region{world=" + String.valueOf(this.getWorld()) + ",x=" + this.getX() + ",z=" + this.getZ() + "}";
    }
}

