/*
 * Decompiled with CFR 0.152.
 */
package net.pl3x.map.core.world;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import libs.com.github.benmanes.caffeine.cache.Caffeine;
import libs.com.github.benmanes.caffeine.cache.LoadingCache;
import net.pl3x.map.core.Keyed;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.configuration.Config;
import net.pl3x.map.core.configuration.PlayersLayerConfig;
import net.pl3x.map.core.configuration.SpawnLayerConfig;
import net.pl3x.map.core.configuration.WorldBorderLayerConfig;
import net.pl3x.map.core.configuration.WorldConfig;
import net.pl3x.map.core.httpd.LiveDataHandler;
import net.pl3x.map.core.image.IconImage;
import net.pl3x.map.core.log.Logger;
import net.pl3x.map.core.markers.Point;
import net.pl3x.map.core.markers.area.Area;
import net.pl3x.map.core.markers.layer.CustomLayer;
import net.pl3x.map.core.markers.layer.Layer;
import net.pl3x.map.core.markers.layer.PlayersLayer;
import net.pl3x.map.core.markers.layer.SpawnLayer;
import net.pl3x.map.core.markers.layer.WorldBorderLayer;
import net.pl3x.map.core.player.Player;
import net.pl3x.map.core.registry.BiomeRegistry;
import net.pl3x.map.core.registry.Registry;
import net.pl3x.map.core.renderer.Renderer;
import net.pl3x.map.core.renderer.task.UpdateLiveData;
import net.pl3x.map.core.renderer.task.UpdateMarkerData;
import net.pl3x.map.core.util.FileUtil;
import net.pl3x.map.core.util.Mathf;
import net.pl3x.map.core.world.BiomeManager;
import net.pl3x.map.core.world.Chunk;
import net.pl3x.map.core.world.Region;
import net.pl3x.map.core.world.RegionModifiedState;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public abstract class World
extends Keyed {
    public static final PathMatcher JSON_MATCHER = FileSystems.getDefault().getPathMatcher("glob:**/*.json");
    public static final PathMatcher MCA_MATCHER = FileSystems.getDefault().getPathMatcher("glob:**/r.*.*.mca");
    public static final PathMatcher PNG_MATCHER = FileSystems.getDefault().getPathMatcher("glob:**/*_*.png");
    private final Path customMarkersDirectory;
    private final Path markersDirectory;
    private final Path regionDirectory;
    private final Path tilesDirectory;
    private final WorldConfig worldConfig;
    private final long seed;
    private final Point spawn;
    private final Type type;
    private final LiveDataHandler liveDataHandler;
    private final BiomeManager biomeManager;
    private final BiomeRegistry biomeRegistry;
    private final Registry<Layer> layerRegistry;
    private final LoadingCache<Long, Region> regionCache;
    private final RegionModifiedState regionModifiedState;
    private final UpdateMarkerData markerTask;
    private final UpdateLiveData liveDataTask;
    private final Map<String, Renderer.Builder> renderers = new LinkedHashMap<String, Renderer.Builder>();

    public World(String name, long seed, Point spawn, Type type, Path regionDirectory) {
        super(name);
        this.seed = seed;
        this.spawn = spawn;
        this.type = type;
        this.liveDataHandler = new LiveDataHandler();
        String safeNameForDirectories = name.replace(":", "-");
        this.regionDirectory = regionDirectory;
        this.tilesDirectory = FileUtil.getTilesDir().resolve(safeNameForDirectories);
        this.customMarkersDirectory = Pl3xMap.api().getMainDir().resolve("markers").resolve(safeNameForDirectories);
        this.markersDirectory = this.getTilesDirectory().resolve("markers");
        FileUtil.createDirs(this.regionDirectory);
        FileUtil.createDirs(this.tilesDirectory);
        FileUtil.createDirs(this.customMarkersDirectory);
        FileUtil.createDirs(this.markersDirectory);
        this.worldConfig = new WorldConfig(this);
        this.biomeManager = new BiomeManager(this.hashSeed(this.getSeed()));
        this.biomeRegistry = new BiomeRegistry();
        this.layerRegistry = new Registry();
        this.regionCache = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).maximumSize(100L).build(this::loadRegion);
        this.regionModifiedState = new RegionModifiedState(this);
        this.markerTask = new UpdateMarkerData(this);
        this.liveDataTask = new UpdateLiveData(this, Config.LIVE_UPDATE_THREADS);
    }

    protected void init() {
        if (!this.isEnabled()) {
            return;
        }
        this.getBiomeRegistry().init(this);
        this.getConfig().RENDER_RENDERERS.forEach((id, icon) -> {
            Renderer.Builder renderer = (Renderer.Builder)Pl3xMap.api().getRendererRegistry().get((String)id);
            if (renderer == null) {
                return;
            }
            Path path = FileUtil.getWebDir().resolve("images/icon/" + icon + ".png");
            try {
                IconImage image = new IconImage((String)icon, ImageIO.read(path.toFile()), "png");
                Pl3xMap.api().getIconRegistry().register(image);
            }
            catch (IOException e) {
                Logger.severe("Cannot load world renderer icon " + String.valueOf(path), e);
            }
            this.renderers.put(renderer.getKey(), renderer);
        });
        if (WorldBorderLayerConfig.ENABLED) {
            Logger.debug("Registering world border layer");
            this.getLayerRegistry().register("pl3xmap_worldborder", new WorldBorderLayer(this));
        }
        if (SpawnLayerConfig.ENABLED) {
            Logger.debug("Registering spawn layer");
            this.getLayerRegistry().register("pl3xmap_spawn", new SpawnLayer(this));
        }
        if (PlayersLayerConfig.ENABLED) {
            Logger.debug("Registering player tracker layer");
            this.getLayerRegistry().register("pl3xmap_players", new PlayersLayer(this));
        }
        Logger.debug("Checking all region files");
        Pl3xMap.api().getRegionProcessor().addRegions(this, this.listRegions(false));
        Logger.debug("Starting marker task");
        Pl3xMap.api().getScheduler().addTask(this.markerTask);
        if (Config.LIVE_UPDATE_ENABLED) {
            Logger.debug("Starting live data task");
            Pl3xMap.api().getScheduler().addTask(this.liveDataTask);
        }
        Logger.debug("Loading custom markers for " + this.getName());
        for (Path file : this.getCustomMarkerFiles()) {
            CustomLayer.load(this, file);
        }
    }

    public void cleanup() {
        this.regionCache.invalidateAll();
        this.getRegionModifiedState().save();
    }

    public Path getCustomMarkersDirectory() {
        return this.customMarkersDirectory;
    }

    public Path getMarkersDirectory() {
        return this.markersDirectory;
    }

    public Path getRegionDirectory() {
        return this.regionDirectory;
    }

    public Path getTilesDirectory() {
        return this.tilesDirectory;
    }

    public WorldConfig getConfig() {
        return this.worldConfig;
    }

    public RegionModifiedState getRegionModifiedState() {
        return this.regionModifiedState;
    }

    public UpdateMarkerData getMarkerTask() {
        return this.markerTask;
    }

    public UpdateLiveData getLiveDataTask() {
        return this.liveDataTask;
    }

    public Map<String, Renderer.Builder> getRenderers() {
        return Collections.unmodifiableMap(this.renderers);
    }

    public boolean isEnabled() {
        return this.getConfig().ENABLED;
    }

    public String getName() {
        return this.getKey();
    }

    public long getSeed() {
        return this.seed;
    }

    public Point getSpawn() {
        return this.spawn;
    }

    public int getSkylight() {
        return this.getConfig().RENDER_SKYLIGHT;
    }

    public Type getType() {
        return this.type;
    }

    public LiveDataHandler getServerSentEventHandler() {
        return this.liveDataHandler;
    }

    public BiomeManager getBiomeManager() {
        return this.biomeManager;
    }

    public BiomeRegistry getBiomeRegistry() {
        return this.biomeRegistry;
    }

    public Registry<Layer> getLayerRegistry() {
        return this.layerRegistry;
    }

    public abstract <T> T getLevel();

    public abstract long hashSeed(long var1);

    public abstract boolean hasCeiling();

    public abstract int getMinBuildHeight();

    public abstract int getMaxBuildHeight();

    public abstract int getDimensionHeight();

    public abstract int getLogicalHeight();

    public abstract double getBorderMinX();

    public abstract double getBorderMinZ();

    public abstract double getBorderMaxX();

    public abstract double getBorderMaxZ();

    public abstract Collection<Player> getPlayers();

    public boolean visibleBlock(int blockX, int blockZ) {
        for (Area area : this.getConfig().VISIBLE_AREAS) {
            if (!area.containsBlock(blockX, blockZ)) continue;
            return true;
        }
        return this.getConfig().VISIBLE_AREAS.isEmpty();
    }

    public boolean visibleChunk(int chunkX, int chunkZ) {
        for (Area area : this.getConfig().VISIBLE_AREAS) {
            if (!area.containsChunk(chunkX, chunkZ)) continue;
            return true;
        }
        return this.getConfig().VISIBLE_AREAS.isEmpty();
    }

    public boolean visibleRegion(int regionX, int regionZ) {
        for (Area area : this.getConfig().VISIBLE_AREAS) {
            if (!area.containsRegion(regionX, regionZ)) continue;
            return true;
        }
        return this.getConfig().VISIBLE_AREAS.isEmpty();
    }

    public Chunk getChunk(@Nullable Region region, int chunkX, int chunkZ) {
        return this.getRegion(region, chunkX >> 5, chunkZ >> 5).getChunk(chunkX, chunkZ);
    }

    public Region getRegion(@Nullable Region region, int regionX, int regionZ) {
        if (region != null && region.getX() == regionX && region.getZ() == regionZ) {
            return region;
        }
        return this.getRegion(Mathf.asLong(regionX, regionZ));
    }

    private Region getRegion(long pos) {
        return this.regionCache.get(pos);
    }

    public void unloadRegion(int regionX, int regionZ) {
        this.unloadRegion(Mathf.asLong(regionX, regionZ));
    }

    private void unloadRegion(long pos) {
        this.regionCache.invalidate(pos);
    }

    public Collection<Path> getRegionFiles() {
        List<Path> list;
        block9: {
            if (!Files.exists(this.getRegionDirectory(), new LinkOption[0])) {
                return Collections.emptySet();
            }
            Stream<Path> stream = Files.list(this.getRegionDirectory());
            try {
                list = stream.filter(MCA_MATCHER::matches).toList();
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to list region files in directory '" + String.valueOf(this.getRegionDirectory().toAbsolutePath()) + "'", e);
                }
            }
            stream.close();
        }
        return list;
    }

    public Collection<Path> getCustomMarkerFiles() {
        List<Path> list;
        block9: {
            if (!Files.exists(this.getCustomMarkersDirectory(), new LinkOption[0])) {
                return Collections.emptySet();
            }
            Stream<Path> stream = Files.list(this.getCustomMarkersDirectory());
            try {
                list = stream.filter(JSON_MATCHER::matches).toList();
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to list custom marker files in directory '" + String.valueOf(this.getCustomMarkersDirectory().toAbsolutePath()) + "'", e);
                }
            }
            stream.close();
        }
        return list;
    }

    public Collection<Point> listRegions(boolean ignoreTimestamp) {
        return FileUtil.regionPathsToPoints(this, this.getRegionFiles(), ignoreTimestamp);
    }

    private Region loadRegion(long pos) {
        int x = Mathf.longToX(pos);
        int z = Mathf.longToZ(pos);
        return new Region(this, x, z, this.getMCAFile(x, z));
    }

    private Path getMCAFile(int regionX, int regionZ) {
        return this.getRegionDirectory().resolve("r." + regionX + "." + regionZ + ".mca");
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        World other = (World)o;
        return this.getLevel() == other.getLevel();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getName());
    }

    @Override
    public abstract String toString();

    public static enum Type {
        OVERWORLD,
        NETHER,
        THE_END,
        CUSTOM;

        private final String name = this.name().toLowerCase(Locale.ROOT);

        public static Type get(String dimension) {
            return switch (dimension) {
                case "minecraft:overworld" -> OVERWORLD;
                case "minecraft:the_nether" -> NETHER;
                case "minecraft:the_end" -> THE_END;
                default -> CUSTOM;
            };
        }

        public String toString() {
            return this.name;
        }
    }
}

