/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.injection;

import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeToken;
import libs.org.checkerframework.checker.nullness.qual.NonNull;
import org.apiguardian.api.API;
import org.immutables.value.Value;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.injection.InjectionRequestImpl;
import org.incendo.cloud.util.annotation.AnnotationAccessor;

@API(status=API.Status.STABLE)
@Value.Immutable
public interface InjectionRequest<C> {
    public static <C> @NonNull InjectionRequest<C> of(@NonNull CommandContext<C> context, @NonNull TypeToken<?> injectedType, @NonNull AnnotationAccessor annotationAccessor) {
        return InjectionRequestImpl.of(context, injectedType, annotationAccessor);
    }

    public static <C> @NonNull InjectionRequest<C> of(@NonNull CommandContext<C> context, @NonNull TypeToken<?> injectedType) {
        return InjectionRequestImpl.of(context, injectedType, AnnotationAccessor.empty());
    }

    public @NonNull CommandContext<C> commandContext();

    public @NonNull TypeToken<?> injectedType();

    @Value.Derived
    default public @NonNull Class<?> injectedClass() {
        return GenericTypeReflector.erase(this.injectedType().getType());
    }

    public @NonNull AnnotationAccessor annotationAccessor();
}

