/*
 * Decompiled with CFR 0.152.
 */
package org.incendo.cloud.parser.standard;

import java.util.Objects;
import java.util.UUID;
import libs.org.checkerframework.checker.nullness.qual.NonNull;
import org.apiguardian.api.API;
import org.incendo.cloud.caption.CaptionVariable;
import org.incendo.cloud.caption.StandardCaptionKeys;
import org.incendo.cloud.component.CommandComponent;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.context.CommandInput;
import org.incendo.cloud.exception.parsing.ParserException;
import org.incendo.cloud.parser.ArgumentParseResult;
import org.incendo.cloud.parser.ArgumentParser;
import org.incendo.cloud.parser.ParserDescriptor;

@API(status=API.Status.STABLE)
public final class UUIDParser<C>
implements ArgumentParser<C, UUID> {
    @API(status=API.Status.STABLE)
    public static <C> @NonNull ParserDescriptor<C, UUID> uuidParser() {
        return ParserDescriptor.of(new UUIDParser<C>(), UUID.class);
    }

    @API(status=API.Status.STABLE)
    public static <C> @NonNull CommandComponent.Builder<C, UUID> uuidComponent() {
        return CommandComponent.builder().parser(UUIDParser.uuidParser());
    }

    @Override
    public @NonNull ArgumentParseResult<UUID> parse(@NonNull CommandContext<C> commandContext, @NonNull CommandInput commandInput) {
        String input = commandInput.readString();
        try {
            UUID uuid = UUID.fromString(input);
            return ArgumentParseResult.success(uuid);
        }
        catch (IllegalArgumentException e) {
            return ArgumentParseResult.failure(new UUIDParseException(input, commandContext));
        }
    }

    @API(status=API.Status.STABLE)
    public static final class UUIDParseException
    extends ParserException {
        private final String input;

        public UUIDParseException(@NonNull String input, @NonNull CommandContext<?> context) {
            super(UUIDParser.class, context, StandardCaptionKeys.ARGUMENT_PARSE_FAILURE_UUID, CaptionVariable.of("input", input));
            this.input = input;
        }

        public String input() {
            return this.input;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UUIDParseException that = (UUIDParseException)o;
            return this.input.equals(that.input);
        }

        public int hashCode() {
            return Objects.hash(this.input);
        }
    }
}

