/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.util.Date;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import libs.io.undertow.client.ClientConnection;
import libs.io.undertow.protocols.ssl.SslConduit;
import libs.io.undertow.server.HttpServerExchange;
import libs.io.undertow.server.ServerConnection;
import libs.io.undertow.server.handlers.sse.ServerSentEventConnection;
import libs.io.undertow.util.HeaderMap;
import libs.io.undertow.util.HttpString;
import libs.org.jboss.logging.BasicLogger;
import libs.org.jboss.logging.Logger;
import libs.org.jboss.logging.annotations.Cause;
import libs.org.jboss.logging.annotations.LogMessage;
import libs.org.jboss.logging.annotations.Message;
import libs.org.jboss.logging.annotations.MessageLogger;
import libs.org.xnio.channels.ReadTimeoutException;
import libs.org.xnio.channels.WriteTimeoutException;
import libs.org.xnio.ssl.SslConnection;

@MessageLogger(projectCode="UT")
public interface UndertowLogger
extends BasicLogger {
    public static final UndertowLogger ROOT_LOGGER = Logger.getMessageLogger(UndertowLogger.class, UndertowLogger.class.getPackage().getName());
    public static final UndertowLogger CLIENT_LOGGER = Logger.getMessageLogger(UndertowLogger.class, ClientConnection.class.getPackage().getName());
    public static final UndertowLogger PREDICATE_LOGGER = Logger.getMessageLogger(UndertowLogger.class, UndertowLogger.class.getPackage().getName() + ".predicate");
    public static final UndertowLogger REQUEST_LOGGER = Logger.getMessageLogger(UndertowLogger.class, UndertowLogger.class.getPackage().getName() + ".request");
    public static final UndertowLogger SESSION_LOGGER = Logger.getMessageLogger(UndertowLogger.class, UndertowLogger.class.getPackage().getName() + ".session");
    public static final UndertowLogger SECURITY_LOGGER = Logger.getMessageLogger(UndertowLogger.class, UndertowLogger.class.getPackage().getName() + ".request.security");
    public static final UndertowLogger PROXY_REQUEST_LOGGER = Logger.getMessageLogger(UndertowLogger.class, UndertowLogger.class.getPackage().getName() + ".proxy");
    public static final UndertowLogger REQUEST_DUMPER_LOGGER = Logger.getMessageLogger(UndertowLogger.class, UndertowLogger.class.getPackage().getName() + ".request.dump");
    public static final UndertowLogger REQUEST_IO_LOGGER = Logger.getMessageLogger(UndertowLogger.class, UndertowLogger.class.getPackage().getName() + ".request.io");
    public static final UndertowLogger ERROR_RESPONSE = Logger.getMessageLogger(UndertowLogger.class, UndertowLogger.class.getPackage().getName() + ".request.error-response");

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5001, value="An exception occurred processing the request")
    public void exceptionProcessingRequest(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5003, value="IOException reading from channel")
    public void ioExceptionReadingFromChannel(@Cause IOException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5005, value="Cannot remove uploaded file %s")
    public void cannotRemoveUploadedFile(Path var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=5006, value="Connection from %s terminated as request header was larger than %s")
    public void requestHeaderWasTooLarge(SocketAddress var1, int var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=5007, value="Request was not fully consumed")
    public void requestWasNotFullyConsumed();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=5008, value="An invalid token '%s' with value '%s' has been received.")
    public void invalidTokenReceived(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=5009, value="A mandatory token %s is missing from the request.")
    public void missingAuthorizationToken(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=5010, value="Verification of authentication tokens for user '%s' has failed using mechanism '%s'.")
    public void authenticationFailed(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5011, value="Ignoring AJP request with prefix %s")
    public void ignoringAjpRequestWithPrefixCode(byte var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=5013, value="An IOException occurred")
    public void ioException(@Cause IOException var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=5014, value="Failed to parse request")
    public void failedToParseRequest(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5015, value="Error rotating access log")
    public void errorRotatingAccessLog(@Cause IOException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5016, value="Error writing access log")
    public void errorWritingAccessLog(@Cause IOException var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5017, value="Unknown variable %s. For the literal percent character use two percent characters: '%%'")
    public void unknownVariable(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5018, value="Exception invoking close listener %s")
    public void exceptionInvokingCloseListener(ServerConnection.CloseListener var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5020, value="Error writing JDBC log")
    public void errorWritingJDBCLog(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5022, value="Exception generating error page %s")
    public void exceptionGeneratingErrorPage(@Cause Exception var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5023, value="Exception handling request to %s")
    public void exceptionHandlingRequest(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5024, value="Could not register resource change listener for caching resource manager, automatic invalidation of cached resource will not work")
    public void couldNotRegisterChangeListener(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5027, value="Timing out request to %s")
    public void timingOutRequest(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5028, value="Proxy request to %s failed")
    public void proxyRequestFailed(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5031, value="Proxy request to %s could not connect to backend server %s")
    public void proxyFailedToConnectToBackend(String var1, URI var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5032, value="Listener not making progress on framed channel, closing channel to prevent infinite loop")
    public void listenerNotProgressing();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5034, value="Remote endpoint failed to send initial settings frame in HTTP2 connection, frame type %s")
    public void remoteEndpointFailedToSendInitialSettings(int var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=5035, value="Closing channel because of parse timeout for remote address %s")
    public void parseRequestTimedOut(SocketAddress var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5036, value="ALPN negotiation failed for %s and no fallback defined, closing connection")
    public void noALPNFallback(SocketAddress var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=5037, value="Name of the cookie containing the session id, %s, had been too long and was truncated to: %s")
    public void stickySessionCookieLengthTruncated(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=5038, value="Balancer created: id: %s, name: %s, stickySession: %s, stickySessionCookie: %s, stickySessionPath: %s, stickySessionRemove: %s, stickySessionForce: %s, waitWorker: %s, maxattempts: %s")
    public void balancerCreated(int var1, String var2, boolean var3, String var4, String var5, boolean var6, boolean var7, int var8, int var9);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=5039, value="Undertow starts mod_cluster proxy advertisements on %s with frequency %s ms")
    public void proxyAdvertisementsStarted(String var1, int var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=5040, value="Gonna send payload:\n%s")
    public void proxyAdvertiseMessagePayload(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5041, value="Cannot send advertise message. Address: %s")
    public void proxyAdvertiseCannotSendMessage(@Cause Exception var1, InetSocketAddress var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=5042, value="Undertow mod_cluster proxy MCMPHandler created")
    public void mcmpHandlerCreated();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5043, value="Error in processing MCMP commands: Type:%s, Mess: %s")
    public void mcmpProcessingError(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=5044, value="Removing node %s")
    public void removingNode(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=5045, value="Registering context %s, for node %s")
    public void registeringContext(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=5046, value="Registering context %s, for node %s, with aliases %s")
    public void registeringContext(String var1, String var2, List<String> var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=5047, value="Unregistering context %s, from node %s")
    public void unregisteringContext(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=5048, value="Node %s in error")
    public void nodeIsInError(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=5049, value="NodeConfig created: connectionURI: %s, balancer: %s, load balancing group: %s, jvmRoute: %s, flushPackets: %s, flushwait: %s, ping: %s,ttl: %s, timeout: %s, maxConnections: %s, cacheConnections: %s, requestQueueSize: %s, queueNewRequests: %s")
    public void nodeConfigCreated(URI var1, String var2, String var3, String var4, boolean var5, int var6, int var7, long var8, int var10, int var11, int var12, int var13, boolean var14);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5050, value="Failed to process management request")
    public void failedToProcessManagementReq(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5051, value="Failed to send ping response")
    public void failedToSendPingResponse(@Cause Exception var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=5052, value="Failed to send ping response, node.getJvmRoute(): %s, jvmRoute: %s")
    public void failedToSendPingResponseDBG(@Cause Exception var1, String var2, String var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=5053, value="Registering node %s, connection: %s")
    public void registeringNode(String var1, URI var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=5054, value="MCMP processing, key: %s, value: %s")
    public void mcmpKeyValue(HttpString var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=5055, value="HttpClientPingTask run for connection: %s")
    public void httpClientPingTask(URI var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=5056, value="Received node load in STATUS message, node jvmRoute: %s, load: %s")
    public void receivedNodeLoad(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=5057, value="Sending MCMP response to destination: %s, HTTP status: %s, Headers: %s, response: %s")
    public void mcmpSendingResponse(InetSocketAddress var1, int var2, HeaderMap var3, String var4);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=5058, value="Could not bind multicast socket to %s (%s address): %s; make sure your multicast address is of the same type as the IP stack (IPv4 or IPv6). Multicast socket will not be bound to an address, but this may lead to cross talking (see http://www.jboss.org/community/docs/DOC-9469 for details).")
    public void potentialCrossTalking(InetAddress var1, String var2, String var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=5060, value="Predicate %s uses old style square braces to define predicates, which will be removed in a future release. predicate[value] should be changed to predicate(value)")
    public void oldStylePredicateSyntax(String var1);

    @Message(id=5061, value="More than %s restarts detected, breaking assumed infinite loop")
    public IllegalStateException maxRestartsExceeded(int var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5062, value="Pattern parse error")
    public void extendedAccessLogPatternParseError(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5063, value="Unable to decode with rest of chars starting: %s")
    public void extendedAccessLogUnknownToken(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5064, value="No closing ) found for in decode")
    public void extendedAccessLogMissingClosing();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5065, value="The next characters couldn't be decoded: %s")
    public void extendedAccessLogCannotDecode(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5066, value="X param for servlet request, couldn't decode value: %s")
    public void extendedAccessLogCannotDecodeXParamValue(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5067, value="X param in wrong format. Needs to be 'x-#(...)'")
    public void extendedAccessLogBadXParam();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=5068, value="Pattern was just empty or whitespace")
    public void extendedAccessLogEmptyPattern();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5069, value="Failed to write JDBC access log")
    public void failedToWriteJdbcAccessLog(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5070, value="Failed to write pre-cached file")
    public void failedToWritePreCachedFile();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5071, value="Undertow request failed %s")
    public void undertowRequestFailed(@Cause Throwable var1, HttpServerExchange var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=5072, value="Thread %s (id=%s) has been active for %s milliseconds (since %s) to serve the same request for %s and may be stuck (configured threshold for this StuckThreadDetectionValve is %s seconds). There is/are %s thread(s) in total that are monitored by this Valve and may be stuck.")
    public void stuckThreadDetected(String var1, long var2, long var4, Date var6, String var7, int var8, int var9, @Cause Throwable var10);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=5073, value="Thread %s (id=%s) was previously reported to be stuck but has completed. It was active for approximately %s milliseconds. There is/are still %s thread(s) that are monitored by this Valve and may be stuck.")
    public void stuckThreadCompleted(String var1, long var2, long var4, int var6);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5074, value="Failed to invoke error callback %s for SSE task")
    public void failedToInvokeFailedCallback(ServerSentEventConnection.EventCallback var1, @Cause Exception var2);

    @Message(id=5075, value="Unable to resolve mod_cluster management host's address for '%s'")
    public IllegalStateException unableToResolveModClusterManagementHost(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5076, value="SSL read loop detected. This should not happen, please report this to the Undertow developers. Current state %s")
    public void sslReadLoopDetected(SslConduit var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5077, value="SSL unwrap buffer overflow detected. This should not happen, please report this to the Undertow developers. Current state %s")
    public void sslBufferOverflow(SslConduit var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5079, value="ALPN negotiation on %s failed")
    public void alpnConnectionFailed(SslConnection var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5080, value="HttpServerExchange cannot have both async IO resumed and dispatch() called in the same cycle")
    public void resumedAndDispatched();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5081, value="Response has already been started, cannot proxy request %s")
    public void cannotProxyStartedRequest(HttpServerExchange var1);

    @Message(id=5082, value="Configured mod_cluster management host address cannot be a wildcard address (%s)!")
    public IllegalArgumentException cannotUseWildcardAddressAsModClusterManagementHost(String var1);

    @Message(id=5083, value="Unexpected end of compressed input")
    public IOException unexpectedEndOfCompressedInput();

    @Message(id=5084, value="Attempted to write %s bytes however content-length has been set to %s")
    public IOException dataLargerThanContentLength(long var1, long var3);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=5085, value="Connection %s for exchange %s was not closed cleanly, forcibly closing connection")
    public void responseWasNotTerminated(ServerConnection var1, HttpServerExchange var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5086, value="Failed to accept SSL request")
    public void failedToAcceptSSLRequest(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5088, value="Failed to execute ServletOutputStream.closeAsync() on IO thread")
    public void closeAsyncFailed(@Cause IOException var1);

    @Message(id=5089, value="Method parameter '%s' cannot be null")
    public IllegalArgumentException nullParameter(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5090, value="Unexpected failure")
    public void handleUnexpectedFailure(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5091, value="Failed to initialize DirectByteBufferDeallocator")
    public void directBufferDeallocatorInitializationFailed(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=5092, value="Failed to free direct buffer")
    public void directBufferDeallocationFailed(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=5093, value="Blocking read timed out")
    public void blockingReadTimedOut(@Cause ReadTimeoutException var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=5094, value="Blocking write timed out")
    public void blockingWriteTimedOut(@Cause WriteTimeoutException var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=5095, value="SSLEngine delegated task was rejected")
    public void sslEngineDelegatedTaskRejected(@Cause RejectedExecutionException var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=5096, value="Authentication failed for digest header %s in %s")
    public void authenticationFailedFor(String var1, HttpServerExchange var2, @Cause Exception var3);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=5097, value="Failed to obtain subject for %s")
    public void failedToObtainSubject(HttpServerExchange var1, @Cause GeneralSecurityException var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=5098, value="GSSAPI negotiation failed for %s")
    public void failedToNegotiateAtGSSAPI(HttpServerExchange var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=5099, value="Failed to create SSO for session '%s'")
    public void failedToCreateSSOForSession(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=5100, value="Failed to list paths for '%s'")
    public void failedToListPathsForFile(Path var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=5101, value="No source to list resources from")
    public void noSourceToListResourcesFrom();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=5102, value="Flushing waiting in a frame more than %s miliseconds. The framed channel will be forcibly closed.")
    public void noFrameflushInTimeout(long var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=5103, value="Cache TTL set to wrong value '%sms'. Defaulting to '%sms'.")
    public void wrongCacheTTLValue(int var1, int var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=5104, value="Could not register resource change listener for caching resource manager, automatic invalidation of cached resource will not work. TTL value configured '%sms'. Defaulting to '%sms'.")
    public void failedToRegisterChangeListener(int var1, int var2, @Cause Exception var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=5105, value="Cache entry content mismatch for '%s'. Expected length '%s', but was '%s'.")
    public void cacheEntryMismatchContent(Object var1, int var2, long var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=5106, value="Content mismatch for '%s'. Expected length '%s', but was '%s'.")
    public void contentEntryMismatch(Object var1, long var2, long var4);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=5107, value="Failed to set web socket timeout.")
    public void failedToSetWSTimeout(@Cause Exception var1);
}

