/*
 * Decompiled with CFR 0.152.
 */
package libs.io.undertow.attribute;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import libs.io.undertow.attribute.ExchangeAttribute;
import libs.io.undertow.attribute.ExchangeAttributeBuilder;
import libs.io.undertow.attribute.ReadOnlyAttributeException;
import libs.io.undertow.server.HttpServerExchange;
import libs.io.undertow.util.DateUtils;

public class DateTimeAttribute
implements ExchangeAttribute {
    public static final String DATE_TIME_SHORT = "%t";
    public static final String DATE_TIME = "%{DATE_TIME}";
    public static final String CUSTOM_TIME = "%{time,";
    public static final ExchangeAttribute INSTANCE = new DateTimeAttribute();
    private final String dateFormat;
    private final ThreadLocal<SimpleDateFormat> cachedFormat;

    private DateTimeAttribute() {
        this.dateFormat = null;
        this.cachedFormat = null;
    }

    public DateTimeAttribute(String dateFormat) {
        this(dateFormat, null);
    }

    public DateTimeAttribute(final String dateFormat, final String timezone) {
        this.dateFormat = dateFormat;
        this.cachedFormat = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                SimpleDateFormat format = new SimpleDateFormat(dateFormat);
                if (timezone != null) {
                    format.setTimeZone(TimeZone.getTimeZone(timezone));
                }
                return format;
            }
        };
    }

    @Override
    public String readAttribute(HttpServerExchange exchange) {
        if (this.dateFormat == null) {
            return DateUtils.toCommonLogFormat(new Date());
        }
        SimpleDateFormat dateFormat = this.cachedFormat.get();
        return dateFormat.format(new Date());
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        throw new ReadOnlyAttributeException("Date time", newValue);
    }

    public String toString() {
        if (this.dateFormat == null) {
            return DATE_TIME;
        }
        return CUSTOM_TIME + this.dateFormat + "}";
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Date Time";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.equals(DateTimeAttribute.DATE_TIME) || token.equals(DateTimeAttribute.DATE_TIME_SHORT)) {
                return INSTANCE;
            }
            if (token.startsWith(DateTimeAttribute.CUSTOM_TIME) && token.endsWith("}")) {
                return new DateTimeAttribute(token.substring(DateTimeAttribute.CUSTOM_TIME.length(), token.length() - 1));
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

